// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class HciClusterDeploymentInfo : IUtf8JsonSerializable, IJsonModel<HciClusterDeploymentInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterDeploymentInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterDeploymentInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterDeploymentInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(SecuritySettings))
            {
                writer.WritePropertyName("securitySettings"u8);
                writer.WriteObjectValue(SecuritySettings, options);
            }
            if (Optional.IsDefined(Observability))
            {
                writer.WritePropertyName("observability"u8);
                writer.WriteObjectValue(Observability, options);
            }
            if (Optional.IsDefined(Cluster))
            {
                writer.WritePropertyName("cluster"u8);
                writer.WriteObjectValue(Cluster, options);
            }
            if (Optional.IsDefined(Storage))
            {
                writer.WritePropertyName("storage"u8);
                writer.WriteObjectValue(Storage, options);
            }
            if (Optional.IsDefined(NamingPrefix))
            {
                writer.WritePropertyName("namingPrefix"u8);
                writer.WriteStringValue(NamingPrefix);
            }
            if (Optional.IsDefined(DomainFqdn))
            {
                writer.WritePropertyName("domainFqdn"u8);
                writer.WriteStringValue(DomainFqdn);
            }
            if (Optional.IsCollectionDefined(InfrastructureNetwork))
            {
                writer.WritePropertyName("infrastructureNetwork"u8);
                writer.WriteStartArray();
                foreach (var item in InfrastructureNetwork)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PhysicalNodes))
            {
                writer.WritePropertyName("physicalNodes"u8);
                writer.WriteStartArray();
                foreach (var item in PhysicalNodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HostNetwork))
            {
                writer.WritePropertyName("hostNetwork"u8);
                writer.WriteObjectValue(HostNetwork, options);
            }
            if (Optional.IsDefined(SdnIntegration))
            {
                writer.WritePropertyName("sdnIntegration"u8);
                writer.WriteObjectValue(SdnIntegration, options);
            }
            if (Optional.IsDefined(AdouPath))
            {
                writer.WritePropertyName("adouPath"u8);
                writer.WriteStringValue(AdouPath);
            }
            if (Optional.IsDefined(SecretsLocation))
            {
                writer.WritePropertyName("secretsLocation"u8);
                writer.WriteStringValue(SecretsLocation);
            }
            if (Optional.IsCollectionDefined(Secrets))
            {
                writer.WritePropertyName("secrets"u8);
                writer.WriteStartArray();
                foreach (var item in Secrets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(OptionalServices))
            {
                writer.WritePropertyName("optionalServices"u8);
                writer.WriteObjectValue(OptionalServices, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HciClusterDeploymentInfo IJsonModel<HciClusterDeploymentInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterDeploymentInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterDeploymentInfo(document.RootElement, options);
        }

        internal static HciClusterDeploymentInfo DeserializeHciClusterDeploymentInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HciClusterDeploymentSecuritySettings securitySettings = default;
            DeploymentSettingObservability observability = default;
            HciDeploymentCluster cluster = default;
            DeploymentSettingStorage storage = default;
            string namingPrefix = default;
            string domainFqdn = default;
            IList<DeploymentSettingInfrastructureNetwork> infrastructureNetwork = default;
            IList<DeploymentSettingPhysicalNodes> physicalNodes = default;
            DeploymentSettingHostNetwork hostNetwork = default;
            SdnIntegration sdnIntegration = default;
            string adouPath = default;
            string secretsLocation = default;
            IList<EceDeploymentSecrets> secrets = default;
            OptionalServices optionalServices = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("securitySettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    securitySettings = HciClusterDeploymentSecuritySettings.DeserializeHciClusterDeploymentSecuritySettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("observability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    observability = DeploymentSettingObservability.DeserializeDeploymentSettingObservability(property.Value, options);
                    continue;
                }
                if (property.NameEquals("cluster"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cluster = HciDeploymentCluster.DeserializeHciDeploymentCluster(property.Value, options);
                    continue;
                }
                if (property.NameEquals("storage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storage = DeploymentSettingStorage.DeserializeDeploymentSettingStorage(property.Value, options);
                    continue;
                }
                if (property.NameEquals("namingPrefix"u8))
                {
                    namingPrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("domainFqdn"u8))
                {
                    domainFqdn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("infrastructureNetwork"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DeploymentSettingInfrastructureNetwork> array = new List<DeploymentSettingInfrastructureNetwork>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeploymentSettingInfrastructureNetwork.DeserializeDeploymentSettingInfrastructureNetwork(item, options));
                    }
                    infrastructureNetwork = array;
                    continue;
                }
                if (property.NameEquals("physicalNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DeploymentSettingPhysicalNodes> array = new List<DeploymentSettingPhysicalNodes>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeploymentSettingPhysicalNodes.DeserializeDeploymentSettingPhysicalNodes(item, options));
                    }
                    physicalNodes = array;
                    continue;
                }
                if (property.NameEquals("hostNetwork"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hostNetwork = DeploymentSettingHostNetwork.DeserializeDeploymentSettingHostNetwork(property.Value, options);
                    continue;
                }
                if (property.NameEquals("sdnIntegration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sdnIntegration = SdnIntegration.DeserializeSdnIntegration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("adouPath"u8))
                {
                    adouPath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secretsLocation"u8))
                {
                    secretsLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secrets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EceDeploymentSecrets> array = new List<EceDeploymentSecrets>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EceDeploymentSecrets.DeserializeEceDeploymentSecrets(item, options));
                    }
                    secrets = array;
                    continue;
                }
                if (property.NameEquals("optionalServices"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    optionalServices = OptionalServices.DeserializeOptionalServices(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterDeploymentInfo(
                securitySettings,
                observability,
                cluster,
                storage,
                namingPrefix,
                domainFqdn,
                infrastructureNetwork ?? new ChangeTrackingList<DeploymentSettingInfrastructureNetwork>(),
                physicalNodes ?? new ChangeTrackingList<DeploymentSettingPhysicalNodes>(),
                hostNetwork,
                sdnIntegration,
                adouPath,
                secretsLocation,
                secrets ?? new ChangeTrackingList<EceDeploymentSecrets>(),
                optionalServices,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecuritySettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  securitySettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecuritySettings))
                {
                    builder.Append("  securitySettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SecuritySettings, options, 2, false, "  securitySettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Observability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  observability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Observability))
                {
                    builder.Append("  observability: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Observability, options, 2, false, "  observability: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Cluster), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cluster: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Cluster))
                {
                    builder.Append("  cluster: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Cluster, options, 2, false, "  cluster: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("StorageConfigurationMode", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storage: ");
                builder.AppendLine("{");
                builder.Append("    configurationMode: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Storage))
                {
                    builder.Append("  storage: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Storage, options, 2, false, "  storage: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NamingPrefix), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  namingPrefix: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NamingPrefix))
                {
                    builder.Append("  namingPrefix: ");
                    if (NamingPrefix.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NamingPrefix}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NamingPrefix}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DomainFqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  domainFqdn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DomainFqdn))
                {
                    builder.Append("  domainFqdn: ");
                    if (DomainFqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DomainFqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DomainFqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InfrastructureNetwork), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  infrastructureNetwork: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(InfrastructureNetwork))
                {
                    if (InfrastructureNetwork.Any())
                    {
                        builder.Append("  infrastructureNetwork: ");
                        builder.AppendLine("[");
                        foreach (var item in InfrastructureNetwork)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  infrastructureNetwork: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PhysicalNodes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  physicalNodes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PhysicalNodes))
                {
                    if (PhysicalNodes.Any())
                    {
                        builder.Append("  physicalNodes: ");
                        builder.AppendLine("[");
                        foreach (var item in PhysicalNodes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  physicalNodes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostNetwork), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hostNetwork: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HostNetwork))
                {
                    builder.Append("  hostNetwork: ");
                    BicepSerializationHelpers.AppendChildObject(builder, HostNetwork, options, 2, false, "  hostNetwork: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("SdnIntegrationNetworkController", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sdnIntegration: ");
                builder.AppendLine("{");
                builder.Append("    networkController: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(SdnIntegration))
                {
                    builder.Append("  sdnIntegration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SdnIntegration, options, 2, false, "  sdnIntegration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdouPath), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  adouPath: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdouPath))
                {
                    builder.Append("  adouPath: ");
                    if (AdouPath.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AdouPath}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AdouPath}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecretsLocation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secretsLocation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecretsLocation))
                {
                    builder.Append("  secretsLocation: ");
                    if (SecretsLocation.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SecretsLocation}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SecretsLocation}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Secrets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secrets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Secrets))
                {
                    if (Secrets.Any())
                    {
                        builder.Append("  secrets: ");
                        builder.AppendLine("[");
                        foreach (var item in Secrets)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  secrets: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("OptionalServicesCustomLocation", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  optionalServices: ");
                builder.AppendLine("{");
                builder.Append("    customLocation: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(OptionalServices))
                {
                    builder.Append("  optionalServices: ");
                    BicepSerializationHelpers.AppendChildObject(builder, OptionalServices, options, 2, false, "  optionalServices: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterDeploymentInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterDeploymentInfo)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterDeploymentInfo IPersistableModel<HciClusterDeploymentInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterDeploymentInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterDeploymentInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterDeploymentInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
