// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Deployment Configuration. </summary>
    public partial class HciClusterDeploymentConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterDeploymentConfiguration"/>. </summary>
        /// <param name="scaleUnits"> Scale units will contains list of deployment data. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scaleUnits"/> is null. </exception>
        public HciClusterDeploymentConfiguration(IEnumerable<DeploymentSettingScaleUnits> scaleUnits)
        {
            Argument.AssertNotNull(scaleUnits, nameof(scaleUnits));

            ScaleUnits = scaleUnits.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterDeploymentConfiguration"/>. </summary>
        /// <param name="version"> deployment template version. </param>
        /// <param name="scaleUnits"> Scale units will contains list of deployment data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterDeploymentConfiguration(string version, IList<DeploymentSettingScaleUnits> scaleUnits, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            ScaleUnits = scaleUnits;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterDeploymentConfiguration"/> for deserialization. </summary>
        internal HciClusterDeploymentConfiguration()
        {
        }

        /// <summary> deployment template version. </summary>
        [WirePath("version")]
        public string Version { get; set; }
        /// <summary> Scale units will contains list of deployment data. </summary>
        [WirePath("scaleUnits")]
        public IList<DeploymentSettingScaleUnits> ScaleUnits { get; }
    }
}
