// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Overall connectivity status for the cluster resource. </summary>
    public readonly partial struct HciClusterConnectivityStatus : IEquatable<HciClusterConnectivityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterConnectivityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterConnectivityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotYetRegisteredValue = "NotYetRegistered";
        private const string ConnectedValue = "Connected";
        private const string NotConnectedRecentlyValue = "NotConnectedRecently";
        private const string PartiallyConnectedValue = "PartiallyConnected";
        private const string DisconnectedValue = "Disconnected";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> NotYetRegistered. </summary>
        public static HciClusterConnectivityStatus NotYetRegistered { get; } = new HciClusterConnectivityStatus(NotYetRegisteredValue);
        /// <summary> Connected. </summary>
        public static HciClusterConnectivityStatus Connected { get; } = new HciClusterConnectivityStatus(ConnectedValue);
        /// <summary> NotConnectedRecently. </summary>
        public static HciClusterConnectivityStatus NotConnectedRecently { get; } = new HciClusterConnectivityStatus(NotConnectedRecentlyValue);
        /// <summary> PartiallyConnected. </summary>
        public static HciClusterConnectivityStatus PartiallyConnected { get; } = new HciClusterConnectivityStatus(PartiallyConnectedValue);
        /// <summary> Disconnected. </summary>
        public static HciClusterConnectivityStatus Disconnected { get; } = new HciClusterConnectivityStatus(DisconnectedValue);
        /// <summary> NotSpecified. </summary>
        public static HciClusterConnectivityStatus NotSpecified { get; } = new HciClusterConnectivityStatus(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="HciClusterConnectivityStatus"/> values are the same. </summary>
        public static bool operator ==(HciClusterConnectivityStatus left, HciClusterConnectivityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterConnectivityStatus"/> values are not the same. </summary>
        public static bool operator !=(HciClusterConnectivityStatus left, HciClusterConnectivityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterConnectivityStatus"/>. </summary>
        public static implicit operator HciClusterConnectivityStatus(string value) => new HciClusterConnectivityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterConnectivityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterConnectivityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
