// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Represents the compliance status of a resource. </summary>
    public readonly partial struct HciClusterComplianceStatus : IEquatable<HciClusterComplianceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterComplianceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterComplianceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CompliantValue = "Compliant";
        private const string NonCompliantValue = "NonCompliant";
        private const string PendingValue = "Pending";

        /// <summary> The resource is compliant. </summary>
        public static HciClusterComplianceStatus Compliant { get; } = new HciClusterComplianceStatus(CompliantValue);
        /// <summary> The resource is non-compliant. </summary>
        public static HciClusterComplianceStatus NonCompliant { get; } = new HciClusterComplianceStatus(NonCompliantValue);
        /// <summary> The resource compliance status is pending. </summary>
        public static HciClusterComplianceStatus Pending { get; } = new HciClusterComplianceStatus(PendingValue);
        /// <summary> Determines if two <see cref="HciClusterComplianceStatus"/> values are the same. </summary>
        public static bool operator ==(HciClusterComplianceStatus left, HciClusterComplianceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterComplianceStatus"/> values are not the same. </summary>
        public static bool operator !=(HciClusterComplianceStatus left, HciClusterComplianceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterComplianceStatus"/>. </summary>
        public static implicit operator HciClusterComplianceStatus(string value) => new HciClusterComplianceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterComplianceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterComplianceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
