// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Represents the compliance assignment type of a resource. </summary>
    public readonly partial struct HciClusterComplianceAssignmentType : IEquatable<HciClusterComplianceAssignmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterComplianceAssignmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterComplianceAssignmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AuditValue = "Audit";
        private const string ApplyAndAutoCorrectValue = "ApplyAndAutoCorrect";

        /// <summary> Report on the state of the machine, but don't make changes. </summary>
        public static HciClusterComplianceAssignmentType Audit { get; } = new HciClusterComplianceAssignmentType(AuditValue);
        /// <summary> Applied to the machine. If it drifts, the local service inside the machine makes a correction at the next evaluation. </summary>
        public static HciClusterComplianceAssignmentType ApplyAndAutoCorrect { get; } = new HciClusterComplianceAssignmentType(ApplyAndAutoCorrectValue);
        /// <summary> Determines if two <see cref="HciClusterComplianceAssignmentType"/> values are the same. </summary>
        public static bool operator ==(HciClusterComplianceAssignmentType left, HciClusterComplianceAssignmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterComplianceAssignmentType"/> values are not the same. </summary>
        public static bool operator !=(HciClusterComplianceAssignmentType left, HciClusterComplianceAssignmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterComplianceAssignmentType"/>. </summary>
        public static implicit operator HciClusterComplianceAssignmentType(string value) => new HciClusterComplianceAssignmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterComplianceAssignmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterComplianceAssignmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
