// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Remote Support Access Level. </summary>
    public readonly partial struct HciClusterAccessLevel : IEquatable<HciClusterAccessLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterAccessLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterAccessLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DiagnosticsValue = "Diagnostics";
        private const string DiagnosticsAndRepairValue = "DiagnosticsAndRepair";

        /// <summary> Diagnostics. </summary>
        public static HciClusterAccessLevel Diagnostics { get; } = new HciClusterAccessLevel(DiagnosticsValue);
        /// <summary> DiagnosticsAndRepair. </summary>
        public static HciClusterAccessLevel DiagnosticsAndRepair { get; } = new HciClusterAccessLevel(DiagnosticsAndRepairValue);
        /// <summary> Determines if two <see cref="HciClusterAccessLevel"/> values are the same. </summary>
        public static bool operator ==(HciClusterAccessLevel left, HciClusterAccessLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterAccessLevel"/> values are not the same. </summary>
        public static bool operator !=(HciClusterAccessLevel left, HciClusterAccessLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterAccessLevel"/>. </summary>
        public static implicit operator HciClusterAccessLevel(string value) => new HciClusterAccessLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterAccessLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterAccessLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
