// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Indicates the way the update content can be downloaded. </summary>
    public readonly partial struct HciAvailabilityType : IEquatable<HciAvailabilityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciAvailabilityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciAvailabilityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocalValue = "Local";
        private const string OnlineValue = "Online";
        private const string NotifyValue = "Notify";

        /// <summary> Local. </summary>
        public static HciAvailabilityType Local { get; } = new HciAvailabilityType(LocalValue);
        /// <summary> Online. </summary>
        public static HciAvailabilityType Online { get; } = new HciAvailabilityType(OnlineValue);
        /// <summary> Notify. </summary>
        public static HciAvailabilityType Notify { get; } = new HciAvailabilityType(NotifyValue);
        /// <summary> Determines if two <see cref="HciAvailabilityType"/> values are the same. </summary>
        public static bool operator ==(HciAvailabilityType left, HciAvailabilityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciAvailabilityType"/> values are not the same. </summary>
        public static bool operator !=(HciAvailabilityType left, HciAvailabilityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciAvailabilityType"/>. </summary>
        public static implicit operator HciAvailabilityType(string value) => new HciAvailabilityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciAvailabilityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciAvailabilityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
