// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> properties for Arc-enabled edge device with HCI OS. </summary>
    public partial class HciArcEnabledEdgeDeviceProperties : HciEdgeDeviceProperties
    {
        /// <summary> Initializes a new instance of <see cref="HciArcEnabledEdgeDeviceProperties"/>. </summary>
        public HciArcEnabledEdgeDeviceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciArcEnabledEdgeDeviceProperties"/>. </summary>
        /// <param name="deviceConfiguration"> Device Configuration. </param>
        /// <param name="provisioningState"> Provisioning state of edgeDevice resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="reportedProperties"> The instance view of all current configurations on HCI device. </param>
        internal HciArcEnabledEdgeDeviceProperties(HciEdgeDeviceConfiguration deviceConfiguration, HciProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData, HciReportedProperties reportedProperties) : base(deviceConfiguration, provisioningState, serializedAdditionalRawData)
        {
            ReportedProperties = reportedProperties;
        }

        /// <summary> The instance view of all current configurations on HCI device. </summary>
        [WirePath("reportedProperties")]
        public HciReportedProperties ReportedProperties { get; }
    }
}
