// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Arc-enabled edge device with HCI OS. </summary>
    public partial class HciArcEnabledEdgeDevice : HciEdgeDeviceData
    {
        /// <summary> Initializes a new instance of <see cref="HciArcEnabledEdgeDevice"/>. </summary>
        public HciArcEnabledEdgeDevice()
        {
            Kind = HciEdgeDeviceKind.HCI;
        }

        /// <summary> Initializes a new instance of <see cref="HciArcEnabledEdgeDevice"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Device kind to support polymorphic resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> properties for Arc-enabled edge device with HCI OS. </param>
        internal HciArcEnabledEdgeDevice(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, HciEdgeDeviceKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, HciArcEnabledEdgeDeviceProperties properties) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            Properties = properties;
            Kind = kind;
        }

        /// <summary> properties for Arc-enabled edge device with HCI OS. </summary>
        [WirePath("properties")]
        public HciArcEnabledEdgeDeviceProperties Properties { get; set; }
    }
}
