// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The DeploymentStatus of AzureStackHCI Cluster. </summary>
    public partial class EceReportedProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EceReportedProperties"/>. </summary>
        internal EceReportedProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EceReportedProperties"/>. </summary>
        /// <param name="validationStatus"> validation status of AzureStackHCI Cluster Deployment. </param>
        /// <param name="deploymentStatus"> Deployment status of AzureStackHCI Cluster Deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EceReportedProperties(EceActionStatus validationStatus, EceActionStatus deploymentStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ValidationStatus = validationStatus;
            DeploymentStatus = deploymentStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> validation status of AzureStackHCI Cluster Deployment. </summary>
        [WirePath("validationStatus")]
        public EceActionStatus ValidationStatus { get; }
        /// <summary> Deployment status of AzureStackHCI Cluster Deployment. </summary>
        [WirePath("deploymentStatus")]
        public EceActionStatus DeploymentStatus { get; }
    }
}
