// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Protected parameters list stored in keyvault. </summary>
    public partial class EceDeploymentSecrets
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EceDeploymentSecrets"/>. </summary>
        public EceDeploymentSecrets()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EceDeploymentSecrets"/>. </summary>
        /// <param name="secretName"> Secret name stored in keyvault. </param>
        /// <param name="eceSecretName"> Secret name expected for Enterprise Cloud Engine (ECE) deployment. </param>
        /// <param name="secretLocation"> Secret URI stored in keyvault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EceDeploymentSecrets(string secretName, EceSecret? eceSecretName, Uri secretLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecretName = secretName;
            EceSecretName = eceSecretName;
            SecretLocation = secretLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Secret name stored in keyvault. </summary>
        [WirePath("secretName")]
        public string SecretName { get; set; }
        /// <summary> Secret name expected for Enterprise Cloud Engine (ECE) deployment. </summary>
        [WirePath("eceSecretName")]
        public EceSecret? EceSecretName { get; set; }
        /// <summary> Secret URI stored in keyvault. </summary>
        [WirePath("secretLocation")]
        public Uri SecretLocation { get; set; }
    }
}
