// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class DeploymentSettingStorageNetworks : IUtf8JsonSerializable, IJsonModel<DeploymentSettingStorageNetworks>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeploymentSettingStorageNetworks>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeploymentSettingStorageNetworks>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingStorageNetworks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingStorageNetworks)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(NetworkAdapterName))
            {
                writer.WritePropertyName("networkAdapterName"u8);
                writer.WriteStringValue(NetworkAdapterName);
            }
            if (Optional.IsDefined(VlanId))
            {
                writer.WritePropertyName("vlanId"u8);
                writer.WriteStringValue(VlanId);
            }
            if (Optional.IsCollectionDefined(StorageAdapterIPInfo))
            {
                writer.WritePropertyName("storageAdapterIPInfo"u8);
                writer.WriteStartArray();
                foreach (var item in StorageAdapterIPInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeploymentSettingStorageNetworks IJsonModel<DeploymentSettingStorageNetworks>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingStorageNetworks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingStorageNetworks)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeploymentSettingStorageNetworks(document.RootElement, options);
        }

        internal static DeploymentSettingStorageNetworks DeserializeDeploymentSettingStorageNetworks(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string networkAdapterName = default;
            string vlanId = default;
            IList<DeploymentSettingStorageAdapterIPInfo> storageAdapterIPInfo = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkAdapterName"u8))
                {
                    networkAdapterName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vlanId"u8))
                {
                    vlanId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageAdapterIPInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DeploymentSettingStorageAdapterIPInfo> array = new List<DeploymentSettingStorageAdapterIPInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeploymentSettingStorageAdapterIPInfo.DeserializeDeploymentSettingStorageAdapterIPInfo(item, options));
                    }
                    storageAdapterIPInfo = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeploymentSettingStorageNetworks(name, networkAdapterName, vlanId, storageAdapterIPInfo ?? new ChangeTrackingList<DeploymentSettingStorageAdapterIPInfo>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkAdapterName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkAdapterName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkAdapterName))
                {
                    builder.Append("  networkAdapterName: ");
                    if (NetworkAdapterName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NetworkAdapterName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NetworkAdapterName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VlanId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  vlanId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VlanId))
                {
                    builder.Append("  vlanId: ");
                    if (VlanId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{VlanId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{VlanId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageAdapterIPInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageAdapterIPInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(StorageAdapterIPInfo))
                {
                    if (StorageAdapterIPInfo.Any())
                    {
                        builder.Append("  storageAdapterIPInfo: ");
                        builder.AppendLine("[");
                        foreach (var item in StorageAdapterIPInfo)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  storageAdapterIPInfo: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DeploymentSettingStorageNetworks>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingStorageNetworks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingStorageNetworks)} does not support writing '{options.Format}' format.");
            }
        }

        DeploymentSettingStorageNetworks IPersistableModel<DeploymentSettingStorageNetworks>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingStorageNetworks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeploymentSettingStorageNetworks(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingStorageNetworks)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeploymentSettingStorageNetworks>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
