// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The QoSPolicyOverrides of a cluster. </summary>
    public partial class DeploymentSettingQosPolicyOverrides
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeploymentSettingQosPolicyOverrides"/>. </summary>
        public DeploymentSettingQosPolicyOverrides()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeploymentSettingQosPolicyOverrides"/>. </summary>
        /// <param name="priorityValue8021ActionCluster"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="priorityValue8021ActionSmb"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="bandwidthPercentageSmb"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeploymentSettingQosPolicyOverrides(string priorityValue8021ActionCluster, string priorityValue8021ActionSmb, string bandwidthPercentageSmb, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PriorityValue8021ActionCluster = priorityValue8021ActionCluster;
            PriorityValue8021ActionSmb = priorityValue8021ActionSmb;
            BandwidthPercentageSmb = bandwidthPercentageSmb;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("priorityValue8021Action_Cluster")]
        public string PriorityValue8021ActionCluster { get; set; }
        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("priorityValue8021Action_SMB")]
        public string PriorityValue8021ActionSmb { get; set; }
        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("bandwidthPercentage_SMB")]
        public string BandwidthPercentageSmb { get; set; }
    }
}
