// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The Observability of AzureStackHCI Cluster. </summary>
    public partial class DeploymentSettingObservability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeploymentSettingObservability"/>. </summary>
        public DeploymentSettingObservability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeploymentSettingObservability"/>. </summary>
        /// <param name="isStreamingDataClientEnabled"> Enables telemetry data to be sent to Microsoft. </param>
        /// <param name="isEULocation"> Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU. </param>
        /// <param name="isEpisodicDataUploadEnabled"> When set to true, collects log data to facilitate quicker issue resolution. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeploymentSettingObservability(bool? isStreamingDataClientEnabled, bool? isEULocation, bool? isEpisodicDataUploadEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsStreamingDataClientEnabled = isStreamingDataClientEnabled;
            IsEULocation = isEULocation;
            IsEpisodicDataUploadEnabled = isEpisodicDataUploadEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Enables telemetry data to be sent to Microsoft. </summary>
        [WirePath("streamingDataClient")]
        public bool? IsStreamingDataClientEnabled { get; set; }
        /// <summary> Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU. </summary>
        [WirePath("euLocation")]
        public bool? IsEULocation { get; set; }
        /// <summary> When set to true, collects log data to facilitate quicker issue resolution. </summary>
        [WirePath("episodicDataUpload")]
        public bool? IsEpisodicDataUploadEnabled { get; set; }
    }
}
