// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class DeploymentSettingNetworkController : IUtf8JsonSerializable, IJsonModel<DeploymentSettingNetworkController>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeploymentSettingNetworkController>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeploymentSettingNetworkController>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingNetworkController>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingNetworkController)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(MacAddressPoolStart))
            {
                writer.WritePropertyName("macAddressPoolStart"u8);
                writer.WriteStringValue(MacAddressPoolStart);
            }
            if (Optional.IsDefined(MacAddressPoolStop))
            {
                writer.WritePropertyName("macAddressPoolStop"u8);
                writer.WriteStringValue(MacAddressPoolStop);
            }
            if (Optional.IsDefined(NetworkVirtualizationEnabled))
            {
                writer.WritePropertyName("networkVirtualizationEnabled"u8);
                writer.WriteBooleanValue(NetworkVirtualizationEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeploymentSettingNetworkController IJsonModel<DeploymentSettingNetworkController>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingNetworkController>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingNetworkController)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeploymentSettingNetworkController(document.RootElement, options);
        }

        internal static DeploymentSettingNetworkController DeserializeDeploymentSettingNetworkController(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string macAddressPoolStart = default;
            string macAddressPoolStop = default;
            bool? networkVirtualizationEnabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("macAddressPoolStart"u8))
                {
                    macAddressPoolStart = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("macAddressPoolStop"u8))
                {
                    macAddressPoolStop = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkVirtualizationEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    networkVirtualizationEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeploymentSettingNetworkController(macAddressPoolStart, macAddressPoolStop, networkVirtualizationEnabled, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MacAddressPoolStart), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  macAddressPoolStart: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MacAddressPoolStart))
                {
                    builder.Append("  macAddressPoolStart: ");
                    if (MacAddressPoolStart.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MacAddressPoolStart}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MacAddressPoolStart}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MacAddressPoolStop), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  macAddressPoolStop: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MacAddressPoolStop))
                {
                    builder.Append("  macAddressPoolStop: ");
                    if (MacAddressPoolStop.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MacAddressPoolStop}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MacAddressPoolStop}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkVirtualizationEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkVirtualizationEnabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkVirtualizationEnabled))
                {
                    builder.Append("  networkVirtualizationEnabled: ");
                    var boolValue = NetworkVirtualizationEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DeploymentSettingNetworkController>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingNetworkController>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingNetworkController)} does not support writing '{options.Format}' format.");
            }
        }

        DeploymentSettingNetworkController IPersistableModel<DeploymentSettingNetworkController>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingNetworkController>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeploymentSettingNetworkController(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingNetworkController)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeploymentSettingNetworkController>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
