// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class DeploymentSettingAdapterPropertyOverrides : IUtf8JsonSerializable, IJsonModel<DeploymentSettingAdapterPropertyOverrides>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeploymentSettingAdapterPropertyOverrides>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeploymentSettingAdapterPropertyOverrides>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingAdapterPropertyOverrides>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingAdapterPropertyOverrides)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(JumboPacket))
            {
                writer.WritePropertyName("jumboPacket"u8);
                writer.WriteStringValue(JumboPacket);
            }
            if (Optional.IsDefined(NetworkDirect))
            {
                writer.WritePropertyName("networkDirect"u8);
                writer.WriteStringValue(NetworkDirect);
            }
            if (Optional.IsDefined(NetworkDirectTechnology))
            {
                writer.WritePropertyName("networkDirectTechnology"u8);
                writer.WriteStringValue(NetworkDirectTechnology);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeploymentSettingAdapterPropertyOverrides IJsonModel<DeploymentSettingAdapterPropertyOverrides>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingAdapterPropertyOverrides>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeploymentSettingAdapterPropertyOverrides)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeploymentSettingAdapterPropertyOverrides(document.RootElement, options);
        }

        internal static DeploymentSettingAdapterPropertyOverrides DeserializeDeploymentSettingAdapterPropertyOverrides(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string jumboPacket = default;
            string networkDirect = default;
            string networkDirectTechnology = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("jumboPacket"u8))
                {
                    jumboPacket = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkDirect"u8))
                {
                    networkDirect = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkDirectTechnology"u8))
                {
                    networkDirectTechnology = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeploymentSettingAdapterPropertyOverrides(jumboPacket, networkDirect, networkDirectTechnology, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JumboPacket), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jumboPacket: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(JumboPacket))
                {
                    builder.Append("  jumboPacket: ");
                    if (JumboPacket.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{JumboPacket}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{JumboPacket}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkDirect), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkDirect: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkDirect))
                {
                    builder.Append("  networkDirect: ");
                    if (NetworkDirect.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NetworkDirect}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NetworkDirect}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkDirectTechnology), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkDirectTechnology: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkDirectTechnology))
                {
                    builder.Append("  networkDirectTechnology: ");
                    if (NetworkDirectTechnology.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NetworkDirectTechnology}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NetworkDirectTechnology}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DeploymentSettingAdapterPropertyOverrides>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingAdapterPropertyOverrides>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingAdapterPropertyOverrides)} does not support writing '{options.Format}' format.");
            }
        }

        DeploymentSettingAdapterPropertyOverrides IPersistableModel<DeploymentSettingAdapterPropertyOverrides>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeploymentSettingAdapterPropertyOverrides>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeploymentSettingAdapterPropertyOverrides(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeploymentSettingAdapterPropertyOverrides)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeploymentSettingAdapterPropertyOverrides>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
