// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Aggregate state of Arc agent across the nodes in this HCI cluster. </summary>
    public readonly partial struct ArcSettingAggregateState : IEquatable<ArcSettingAggregateState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArcSettingAggregateState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArcSettingAggregateState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ErrorValue = "Error";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";
        private const string DeletedValue = "Deleted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string MovingValue = "Moving";
        private const string PartiallySucceededValue = "PartiallySucceeded";
        private const string PartiallyConnectedValue = "PartiallyConnected";
        private const string InProgressValue = "InProgress";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";
        private const string DisableInProgressValue = "DisableInProgress";

        /// <summary> NotSpecified. </summary>
        public static ArcSettingAggregateState NotSpecified { get; } = new ArcSettingAggregateState(NotSpecifiedValue);
        /// <summary> Error. </summary>
        public static ArcSettingAggregateState Error { get; } = new ArcSettingAggregateState(ErrorValue);
        /// <summary> Succeeded. </summary>
        public static ArcSettingAggregateState Succeeded { get; } = new ArcSettingAggregateState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static ArcSettingAggregateState Canceled { get; } = new ArcSettingAggregateState(CanceledValue);
        /// <summary> Failed. </summary>
        public static ArcSettingAggregateState Failed { get; } = new ArcSettingAggregateState(FailedValue);
        /// <summary> Connected. </summary>
        public static ArcSettingAggregateState Connected { get; } = new ArcSettingAggregateState(ConnectedValue);
        /// <summary> Disconnected. </summary>
        public static ArcSettingAggregateState Disconnected { get; } = new ArcSettingAggregateState(DisconnectedValue);
        /// <summary> Deleted. </summary>
        public static ArcSettingAggregateState Deleted { get; } = new ArcSettingAggregateState(DeletedValue);
        /// <summary> Creating. </summary>
        public static ArcSettingAggregateState Creating { get; } = new ArcSettingAggregateState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ArcSettingAggregateState Updating { get; } = new ArcSettingAggregateState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ArcSettingAggregateState Deleting { get; } = new ArcSettingAggregateState(DeletingValue);
        /// <summary> Moving. </summary>
        public static ArcSettingAggregateState Moving { get; } = new ArcSettingAggregateState(MovingValue);
        /// <summary> PartiallySucceeded. </summary>
        public static ArcSettingAggregateState PartiallySucceeded { get; } = new ArcSettingAggregateState(PartiallySucceededValue);
        /// <summary> PartiallyConnected. </summary>
        public static ArcSettingAggregateState PartiallyConnected { get; } = new ArcSettingAggregateState(PartiallyConnectedValue);
        /// <summary> InProgress. </summary>
        public static ArcSettingAggregateState InProgress { get; } = new ArcSettingAggregateState(InProgressValue);
        /// <summary> Accepted. </summary>
        public static ArcSettingAggregateState Accepted { get; } = new ArcSettingAggregateState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static ArcSettingAggregateState Provisioning { get; } = new ArcSettingAggregateState(ProvisioningValue);
        /// <summary> DisableInProgress. </summary>
        public static ArcSettingAggregateState DisableInProgress { get; } = new ArcSettingAggregateState(DisableInProgressValue);
        /// <summary> Determines if two <see cref="ArcSettingAggregateState"/> values are the same. </summary>
        public static bool operator ==(ArcSettingAggregateState left, ArcSettingAggregateState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArcSettingAggregateState"/> values are not the same. </summary>
        public static bool operator !=(ArcSettingAggregateState left, ArcSettingAggregateState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArcSettingAggregateState"/>. </summary>
        public static implicit operator ArcSettingAggregateState(string value) => new ArcSettingAggregateState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArcSettingAggregateState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArcSettingAggregateState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
