// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The ArcPasswordCredential. </summary>
    public partial class ArcPasswordCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArcPasswordCredential"/>. </summary>
        internal ArcPasswordCredential()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArcPasswordCredential"/>. </summary>
        /// <param name="secretText"></param>
        /// <param name="keyId"></param>
        /// <param name="startOn"></param>
        /// <param name="endOn"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArcPasswordCredential(string secretText, string keyId, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecretText = secretText;
            KeyId = keyId;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the secret text. </summary>
        [WirePath("secretText")]
        public string SecretText { get; }
        /// <summary> Gets the key id. </summary>
        [WirePath("keyId")]
        public string KeyId { get; }
        /// <summary> Gets the start on. </summary>
        [WirePath("startDateTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> Gets the end on. </summary>
        [WirePath("endDateTime")]
        public DateTimeOffset? EndOn { get; }
    }
}
