// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Extension Details to update. </summary>
    public partial class ArcExtensionPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArcExtensionPatch"/>. </summary>
        public ArcExtensionPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArcExtensionPatch"/>. </summary>
        /// <param name="extensionParameters"> Describes the properties of a Machine Extension that can be updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArcExtensionPatch(ArcExtensionPatchContent extensionParameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExtensionParameters = extensionParameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes the properties of a Machine Extension that can be updated. </summary>
        [WirePath("properties.extensionParameters")]
        public ArcExtensionPatchContent ExtensionParameters { get; set; }
    }
}
