// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Properties for a particular default extension category. </summary>
    public partial class ArcDefaultExtensionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ArcDefaultExtensionDetails"/>. </summary>
        internal ArcDefaultExtensionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArcDefaultExtensionDetails"/>. </summary>
        /// <param name="category"> Default extension category. </param>
        /// <param name="consentOn"> Consent time for extension category. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ArcDefaultExtensionDetails(string category, DateTimeOffset? consentOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Category = category;
            ConsentOn = consentOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Default extension category. </summary>
        [WirePath("category")]
        public string Category { get; }
        /// <summary> Consent time for extension category. </summary>
        [WirePath("consentTime")]
        public DateTimeOffset? ConsentOn { get; }
    }
}
