// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Hci
{
    internal class HciEdgeDeviceOperationSource : IOperationSource<HciEdgeDeviceResource>
    {
        private readonly ArmClient _client;

        internal HciEdgeDeviceOperationSource(ArmClient client)
        {
            _client = client;
        }

        HciEdgeDeviceResource IOperationSource<HciEdgeDeviceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HciEdgeDeviceData.DeserializeHciEdgeDeviceData(document.RootElement);
            return new HciEdgeDeviceResource(_client, data);
        }

        async ValueTask<HciEdgeDeviceResource> IOperationSource<HciEdgeDeviceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HciEdgeDeviceData.DeserializeHciEdgeDeviceData(document.RootElement);
            return new HciEdgeDeviceResource(_client, data);
        }
    }
}
