// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Hci
{
    internal class HciClusterDeploymentSettingOperationSource : IOperationSource<HciClusterDeploymentSettingResource>
    {
        private readonly ArmClient _client;

        internal HciClusterDeploymentSettingOperationSource(ArmClient client)
        {
            _client = client;
        }

        HciClusterDeploymentSettingResource IOperationSource<HciClusterDeploymentSettingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HciClusterDeploymentSettingData.DeserializeHciClusterDeploymentSettingData(document.RootElement);
            return new HciClusterDeploymentSettingResource(_client, data);
        }

        async ValueTask<HciClusterDeploymentSettingResource> IOperationSource<HciClusterDeploymentSettingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HciClusterDeploymentSettingData.DeserializeHciClusterDeploymentSettingData(document.RootElement);
            return new HciClusterDeploymentSettingResource(_client, data);
        }
    }
}
