// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Hci
{
    internal class ArcExtensionOperationSource : IOperationSource<ArcExtensionResource>
    {
        private readonly ArmClient _client;

        internal ArcExtensionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ArcExtensionResource IOperationSource<ArcExtensionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ArcExtensionData.DeserializeArcExtensionData(document.RootElement);
            return new ArcExtensionResource(_client, data);
        }

        async ValueTask<ArcExtensionResource> IOperationSource<ArcExtensionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ArcExtensionData.DeserializeArcExtensionData(document.RootElement);
            return new ArcExtensionResource(_client, data);
        }
    }
}
