// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Hci.Models;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A Class representing a HciEdgeDevice along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="HciEdgeDeviceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetHciEdgeDeviceResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetHciEdgeDevice method.
    /// </summary>
    public partial class HciEdgeDeviceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="HciEdgeDeviceResource"/> instance. </summary>
        /// <param name="resourceUri"> The resourceUri. </param>
        /// <param name="edgeDeviceName"> The edgeDeviceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceUri, string edgeDeviceName)
        {
            var resourceId = $"{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _hciEdgeDeviceEdgeDevicesClientDiagnostics;
        private readonly EdgeDevicesRestOperations _hciEdgeDeviceEdgeDevicesRestClient;
        private readonly HciEdgeDeviceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.AzureStackHCI/edgeDevices";

        /// <summary> Initializes a new instance of the <see cref="HciEdgeDeviceResource"/> class for mocking. </summary>
        protected HciEdgeDeviceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="HciEdgeDeviceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal HciEdgeDeviceResource(ArmClient client, HciEdgeDeviceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="HciEdgeDeviceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal HciEdgeDeviceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _hciEdgeDeviceEdgeDevicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Hci", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string hciEdgeDeviceEdgeDevicesApiVersion);
            _hciEdgeDeviceEdgeDevicesRestClient = new EdgeDevicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, hciEdgeDeviceEdgeDevicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual HciEdgeDeviceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<HciEdgeDeviceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Get");
            scope.Start();
            try
            {
                var response = await _hciEdgeDeviceEdgeDevicesRestClient.GetAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciEdgeDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<HciEdgeDeviceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Get");
            scope.Start();
            try
            {
                var response = _hciEdgeDeviceEdgeDevicesRestClient.Get(Id.Parent, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciEdgeDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Delete");
            scope.Start();
            try
            {
                var response = await _hciEdgeDeviceEdgeDevicesRestClient.DeleteAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new HciArmOperation(_hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateDeleteRequest(Id.Parent, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Delete");
            scope.Start();
            try
            {
                var response = _hciEdgeDeviceEdgeDevicesRestClient.Delete(Id.Parent, Id.Name, cancellationToken);
                var operation = new HciArmOperation(_hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateDeleteRequest(Id.Parent, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<HciEdgeDeviceResource>> UpdateAsync(WaitUntil waitUntil, HciEdgeDeviceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Update");
            scope.Start();
            try
            {
                var response = await _hciEdgeDeviceEdgeDevicesRestClient.CreateOrUpdateAsync(Id.Parent, Id.Name, data, cancellationToken).ConfigureAwait(false);
                var operation = new HciArmOperation<HciEdgeDeviceResource>(new HciEdgeDeviceOperationSource(Client), _hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateCreateOrUpdateRequest(Id.Parent, Id.Name, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<HciEdgeDeviceResource> Update(WaitUntil waitUntil, HciEdgeDeviceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Update");
            scope.Start();
            try
            {
                var response = _hciEdgeDeviceEdgeDevicesRestClient.CreateOrUpdate(Id.Parent, Id.Name, data, cancellationToken);
                var operation = new HciArmOperation<HciEdgeDeviceResource>(new HciEdgeDeviceOperationSource(Client), _hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateCreateOrUpdateRequest(Id.Parent, Id.Name, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// A long-running resource action.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}/validate</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Validate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> The content of the action request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<HciEdgeDeviceValidateResult>> ValidateAsync(WaitUntil waitUntil, HciEdgeDeviceValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Validate");
            scope.Start();
            try
            {
                var response = await _hciEdgeDeviceEdgeDevicesRestClient.ValidateAsync(Id.Parent, Id.Name, content, cancellationToken).ConfigureAwait(false);
                var operation = new HciArmOperation<HciEdgeDeviceValidateResult>(new HciEdgeDeviceValidateResultOperationSource(), _hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateValidateRequest(Id.Parent, Id.Name, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// A long-running resource action.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}/validate</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Validate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> The content of the action request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<HciEdgeDeviceValidateResult> Validate(WaitUntil waitUntil, HciEdgeDeviceValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _hciEdgeDeviceEdgeDevicesClientDiagnostics.CreateScope("HciEdgeDeviceResource.Validate");
            scope.Start();
            try
            {
                var response = _hciEdgeDeviceEdgeDevicesRestClient.Validate(Id.Parent, Id.Name, content, cancellationToken);
                var operation = new HciArmOperation<HciEdgeDeviceValidateResult>(new HciEdgeDeviceValidateResultOperationSource(), _hciEdgeDeviceEdgeDevicesClientDiagnostics, Pipeline, _hciEdgeDeviceEdgeDevicesRestClient.CreateValidateRequest(Id.Parent, Id.Name, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
