// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A class representing the HciClusterUpdateSummary data model.
    /// Get the update summaries for the cluster
    /// </summary>
    public partial class HciClusterUpdateSummaryData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdateSummaryData"/>. </summary>
        public HciClusterUpdateSummaryData()
        {
            PackageVersions = new ChangeTrackingList<HciPackageVersionInfo>();
            HealthCheckResult = new ChangeTrackingList<HciPrecheckResult>();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdateSummaryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="provisioningState"> Provisioning state of the UpdateSummaries proxy resource. </param>
        /// <param name="oemFamily"> OEM family name. </param>
        /// <param name="currentOemVersion"> Current OEM Version. </param>
        /// <param name="hardwareModel"> Name of the hardware model. </param>
        /// <param name="packageVersions"> Current version of each updatable component. </param>
        /// <param name="currentVersion"> Current Solution Bundle version of the stamp. </param>
        /// <param name="currentSbeVersion"> Current Sbe version of the stamp. </param>
        /// <param name="lastUpdatedOn"> Last time an update installation completed successfully. </param>
        /// <param name="lastCheckedOn"> Last time the update service successfully checked for updates. </param>
        /// <param name="healthState"> Overall health state for update-specific health checks. </param>
        /// <param name="healthCheckResult"> An array of pre-check result objects. </param>
        /// <param name="healthCheckOn"> Last time the package-specific checks were run. </param>
        /// <param name="state"> Overall update state of the stamp. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterUpdateSummaryData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, HciProvisioningState? provisioningState, string oemFamily, string currentOemVersion, string hardwareModel, IList<HciPackageVersionInfo> packageVersions, string currentVersion, string currentSbeVersion, DateTimeOffset? lastUpdatedOn, DateTimeOffset? lastCheckedOn, HciHealthState? healthState, IList<HciPrecheckResult> healthCheckResult, DateTimeOffset? healthCheckOn, HciClusterUpdateState? state, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            ProvisioningState = provisioningState;
            OemFamily = oemFamily;
            CurrentOemVersion = currentOemVersion;
            HardwareModel = hardwareModel;
            PackageVersions = packageVersions;
            CurrentVersion = currentVersion;
            CurrentSbeVersion = currentSbeVersion;
            LastUpdatedOn = lastUpdatedOn;
            LastCheckedOn = lastCheckedOn;
            HealthState = healthState;
            HealthCheckResult = healthCheckResult;
            HealthCheckOn = healthCheckOn;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; set; }
        /// <summary> Provisioning state of the UpdateSummaries proxy resource. </summary>
        [WirePath("properties.provisioningState")]
        public HciProvisioningState? ProvisioningState { get; }
        /// <summary> OEM family name. </summary>
        [WirePath("properties.oemFamily")]
        public string OemFamily { get; set; }
        /// <summary> Current OEM Version. </summary>
        [WirePath("properties.currentOemVersion")]
        public string CurrentOemVersion { get; set; }
        /// <summary> Name of the hardware model. </summary>
        [WirePath("properties.hardwareModel")]
        public string HardwareModel { get; set; }
        /// <summary> Current version of each updatable component. </summary>
        [WirePath("properties.packageVersions")]
        public IList<HciPackageVersionInfo> PackageVersions { get; }
        /// <summary> Current Solution Bundle version of the stamp. </summary>
        [WirePath("properties.currentVersion")]
        public string CurrentVersion { get; set; }
        /// <summary> Current Sbe version of the stamp. </summary>
        [WirePath("properties.currentSbeVersion")]
        public string CurrentSbeVersion { get; set; }
        /// <summary> Last time an update installation completed successfully. </summary>
        [WirePath("properties.lastUpdated")]
        public DateTimeOffset? LastUpdatedOn { get; set; }
        /// <summary> Last time the update service successfully checked for updates. </summary>
        [WirePath("properties.lastChecked")]
        public DateTimeOffset? LastCheckedOn { get; set; }
        /// <summary> Overall health state for update-specific health checks. </summary>
        [WirePath("properties.healthState")]
        public HciHealthState? HealthState { get; set; }
        /// <summary> An array of pre-check result objects. </summary>
        [WirePath("properties.healthCheckResult")]
        public IList<HciPrecheckResult> HealthCheckResult { get; }
        /// <summary> Last time the package-specific checks were run. </summary>
        [WirePath("properties.healthCheckDate")]
        public DateTimeOffset? HealthCheckOn { get; set; }
        /// <summary> Overall update state of the stamp. </summary>
        [WirePath("properties.state")]
        public HciClusterUpdateState? State { get; set; }
    }
}
