// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    public partial class HciClusterUpdateSummaryData : IUtf8JsonSerializable, IJsonModel<HciClusterUpdateSummaryData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterUpdateSummaryData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterUpdateSummaryData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateSummaryData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterUpdateSummaryData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(OemFamily))
            {
                writer.WritePropertyName("oemFamily"u8);
                writer.WriteStringValue(OemFamily);
            }
            if (Optional.IsDefined(CurrentOemVersion))
            {
                writer.WritePropertyName("currentOemVersion"u8);
                writer.WriteStringValue(CurrentOemVersion);
            }
            if (Optional.IsDefined(HardwareModel))
            {
                writer.WritePropertyName("hardwareModel"u8);
                writer.WriteStringValue(HardwareModel);
            }
            if (Optional.IsCollectionDefined(PackageVersions))
            {
                writer.WritePropertyName("packageVersions"u8);
                writer.WriteStartArray();
                foreach (var item in PackageVersions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(CurrentVersion))
            {
                writer.WritePropertyName("currentVersion"u8);
                writer.WriteStringValue(CurrentVersion);
            }
            if (Optional.IsDefined(CurrentSbeVersion))
            {
                writer.WritePropertyName("currentSbeVersion"u8);
                writer.WriteStringValue(CurrentSbeVersion);
            }
            if (Optional.IsDefined(LastUpdatedOn))
            {
                writer.WritePropertyName("lastUpdated"u8);
                writer.WriteStringValue(LastUpdatedOn.Value, "O");
            }
            if (Optional.IsDefined(LastCheckedOn))
            {
                writer.WritePropertyName("lastChecked"u8);
                writer.WriteStringValue(LastCheckedOn.Value, "O");
            }
            if (Optional.IsDefined(HealthState))
            {
                writer.WritePropertyName("healthState"u8);
                writer.WriteStringValue(HealthState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(HealthCheckResult))
            {
                writer.WritePropertyName("healthCheckResult"u8);
                writer.WriteStartArray();
                foreach (var item in HealthCheckResult)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HealthCheckOn))
            {
                writer.WritePropertyName("healthCheckDate"u8);
                writer.WriteStringValue(HealthCheckOn.Value, "O");
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            writer.WriteEndObject();
        }

        HciClusterUpdateSummaryData IJsonModel<HciClusterUpdateSummaryData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateSummaryData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterUpdateSummaryData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterUpdateSummaryData(document.RootElement, options);
        }

        internal static HciClusterUpdateSummaryData DeserializeHciClusterUpdateSummaryData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            HciProvisioningState? provisioningState = default;
            string oemFamily = default;
            string currentOemVersion = default;
            string hardwareModel = default;
            IList<HciPackageVersionInfo> packageVersions = default;
            string currentVersion = default;
            string currentSbeVersion = default;
            DateTimeOffset? lastUpdated = default;
            DateTimeOffset? lastChecked = default;
            HciHealthState? healthState = default;
            IList<HciPrecheckResult> healthCheckResult = default;
            DateTimeOffset? healthCheckDate = default;
            HciClusterUpdateState? state = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new HciProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("oemFamily"u8))
                        {
                            oemFamily = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentOemVersion"u8))
                        {
                            currentOemVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("hardwareModel"u8))
                        {
                            hardwareModel = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("packageVersions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HciPackageVersionInfo> array = new List<HciPackageVersionInfo>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HciPackageVersionInfo.DeserializeHciPackageVersionInfo(item, options));
                            }
                            packageVersions = array;
                            continue;
                        }
                        if (property0.NameEquals("currentVersion"u8))
                        {
                            currentVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentSbeVersion"u8))
                        {
                            currentSbeVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastUpdated"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastUpdated = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastChecked"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastChecked = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("healthState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            healthState = new HciHealthState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("healthCheckResult"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HciPrecheckResult> array = new List<HciPrecheckResult>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HciPrecheckResult.DeserializeHciPrecheckResult(item, options));
                            }
                            healthCheckResult = array;
                            continue;
                        }
                        if (property0.NameEquals("healthCheckDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            healthCheckDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new HciClusterUpdateState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterUpdateSummaryData(
                id,
                name,
                type,
                systemData,
                location,
                provisioningState,
                oemFamily,
                currentOemVersion,
                hardwareModel,
                packageVersions ?? new ChangeTrackingList<HciPackageVersionInfo>(),
                currentVersion,
                currentSbeVersion,
                lastUpdated,
                lastChecked,
                healthState,
                healthCheckResult ?? new ChangeTrackingList<HciPrecheckResult>(),
                healthCheckDate,
                state,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Location))
                {
                    builder.Append("  location: ");
                    builder.AppendLine($"'{Location.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OemFamily), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    oemFamily: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OemFamily))
                {
                    builder.Append("    oemFamily: ");
                    if (OemFamily.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OemFamily}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OemFamily}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentOemVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentOemVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentOemVersion))
                {
                    builder.Append("    currentOemVersion: ");
                    if (CurrentOemVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentOemVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentOemVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HardwareModel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hardwareModel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HardwareModel))
                {
                    builder.Append("    hardwareModel: ");
                    if (HardwareModel.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HardwareModel}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HardwareModel}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PackageVersions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    packageVersions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PackageVersions))
                {
                    if (PackageVersions.Any())
                    {
                        builder.Append("    packageVersions: ");
                        builder.AppendLine("[");
                        foreach (var item in PackageVersions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    packageVersions: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentVersion))
                {
                    builder.Append("    currentVersion: ");
                    if (CurrentVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentSbeVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentSbeVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentSbeVersion))
                {
                    builder.Append("    currentSbeVersion: ");
                    if (CurrentSbeVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentSbeVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentSbeVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastUpdatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastUpdated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastUpdatedOn))
                {
                    builder.Append("    lastUpdated: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastUpdatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastCheckedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastChecked: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastCheckedOn))
                {
                    builder.Append("    lastChecked: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastCheckedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HealthState))
                {
                    builder.Append("    healthState: ");
                    builder.AppendLine($"'{HealthState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthCheckResult), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthCheckResult: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(HealthCheckResult))
                {
                    if (HealthCheckResult.Any())
                    {
                        builder.Append("    healthCheckResult: ");
                        builder.AppendLine("[");
                        foreach (var item in HealthCheckResult)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    healthCheckResult: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthCheckOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthCheckDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HealthCheckOn))
                {
                    builder.Append("    healthCheckDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(HealthCheckOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("    state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterUpdateSummaryData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateSummaryData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterUpdateSummaryData)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterUpdateSummaryData IPersistableModel<HciClusterUpdateSummaryData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateSummaryData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterUpdateSummaryData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterUpdateSummaryData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterUpdateSummaryData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
