// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A class representing the HciClusterUpdateRun data model.
    /// Details of an Update run
    /// </summary>
    public partial class HciClusterUpdateRunData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdateRunData"/>. </summary>
        public HciClusterUpdateRunData()
        {
            Steps = new ChangeTrackingList<HciUpdateStep>();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdateRunData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="provisioningState"> Provisioning state of the UpdateRuns proxy resource. </param>
        /// <param name="timeStarted"> Timestamp of the update run was started. </param>
        /// <param name="lastUpdatedOn"> Timestamp of the most recently completed step in the update run. </param>
        /// <param name="duration"> Duration of the update run. </param>
        /// <param name="state"> State of the update run. </param>
        /// <param name="namePropertiesProgressName"> Name of the step. </param>
        /// <param name="description"> More detailed description of the step. </param>
        /// <param name="errorMessage"> Error message, specified if the step is in a failed state. </param>
        /// <param name="status"> Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'. </param>
        /// <param name="startOn"> When the step started, or empty if it has not started executing. </param>
        /// <param name="endOn"> When the step reached a terminal state. </param>
        /// <param name="lastCompletedOn"> Completion time of this step or the last completed sub-step. </param>
        /// <param name="expectedExecutionTime"> Expected execution time of a given step. This is optionally authored in the update action plan and can be empty. </param>
        /// <param name="steps"> Recursive model for child steps of this step. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterUpdateRunData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, HciProvisioningState? provisioningState, DateTimeOffset? timeStarted, DateTimeOffset? lastUpdatedOn, string duration, UpdateRunPropertiesState? state, string namePropertiesProgressName, string description, string errorMessage, string status, DateTimeOffset? startOn, DateTimeOffset? endOn, DateTimeOffset? lastCompletedOn, string expectedExecutionTime, IList<HciUpdateStep> steps, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            ProvisioningState = provisioningState;
            TimeStarted = timeStarted;
            LastUpdatedOn = lastUpdatedOn;
            Duration = duration;
            State = state;
            NamePropertiesProgressName = namePropertiesProgressName;
            Description = description;
            ErrorMessage = errorMessage;
            Status = status;
            StartOn = startOn;
            EndOn = endOn;
            LastCompletedOn = lastCompletedOn;
            ExpectedExecutionTime = expectedExecutionTime;
            Steps = steps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; set; }
        /// <summary> Provisioning state of the UpdateRuns proxy resource. </summary>
        [WirePath("properties.provisioningState")]
        public HciProvisioningState? ProvisioningState { get; }
        /// <summary> Timestamp of the update run was started. </summary>
        [WirePath("properties.timeStarted")]
        public DateTimeOffset? TimeStarted { get; set; }
        /// <summary> Timestamp of the most recently completed step in the update run. </summary>
        [WirePath("properties.lastUpdatedTime")]
        public DateTimeOffset? LastUpdatedOn { get; set; }
        /// <summary> Duration of the update run. </summary>
        [WirePath("properties.duration")]
        public string Duration { get; set; }
        /// <summary> State of the update run. </summary>
        [WirePath("properties.state")]
        public UpdateRunPropertiesState? State { get; set; }
        /// <summary> Name of the step. </summary>
        [WirePath("properties.name")]
        public string NamePropertiesProgressName { get; set; }
        /// <summary> More detailed description of the step. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> Error message, specified if the step is in a failed state. </summary>
        [WirePath("properties.errorMessage")]
        public string ErrorMessage { get; set; }
        /// <summary> Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'. </summary>
        [WirePath("properties.status")]
        public string Status { get; set; }
        /// <summary> When the step started, or empty if it has not started executing. </summary>
        [WirePath("properties.startTimeUtc")]
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> When the step reached a terminal state. </summary>
        [WirePath("properties.endTimeUtc")]
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Completion time of this step or the last completed sub-step. </summary>
        [WirePath("properties.lastUpdatedTimeUtc")]
        public DateTimeOffset? LastCompletedOn { get; set; }
        /// <summary> Expected execution time of a given step. This is optionally authored in the update action plan and can be empty. </summary>
        [WirePath("properties.expectedExecutionTime")]
        public string ExpectedExecutionTime { get; set; }
        /// <summary> Recursive model for child steps of this step. </summary>
        [WirePath("properties.steps")]
        public IList<HciUpdateStep> Steps { get; }
    }
}
