// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A class representing a collection of <see cref="HciClusterUpdateRunResource"/> and their operations.
    /// Each <see cref="HciClusterUpdateRunResource"/> in the collection will belong to the same instance of <see cref="HciClusterUpdateResource"/>.
    /// To get a <see cref="HciClusterUpdateRunCollection"/> instance call the GetHciClusterUpdateRuns method from an instance of <see cref="HciClusterUpdateResource"/>.
    /// </summary>
    public partial class HciClusterUpdateRunCollection : ArmCollection, IEnumerable<HciClusterUpdateRunResource>, IAsyncEnumerable<HciClusterUpdateRunResource>
    {
        private readonly ClientDiagnostics _hciClusterUpdateRunUpdateRunsClientDiagnostics;
        private readonly UpdateRunsRestOperations _hciClusterUpdateRunUpdateRunsRestClient;

        /// <summary> Initializes a new instance of the <see cref="HciClusterUpdateRunCollection"/> class for mocking. </summary>
        protected HciClusterUpdateRunCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="HciClusterUpdateRunCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal HciClusterUpdateRunCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _hciClusterUpdateRunUpdateRunsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Hci", HciClusterUpdateRunResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(HciClusterUpdateRunResource.ResourceType, out string hciClusterUpdateRunUpdateRunsApiVersion);
            _hciClusterUpdateRunUpdateRunsRestClient = new UpdateRunsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, hciClusterUpdateRunUpdateRunsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != HciClusterUpdateResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, HciClusterUpdateResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Put Update runs for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="data"> Properties of the updateRuns object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<HciClusterUpdateRunResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string updateRunName, HciClusterUpdateRunData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _hciClusterUpdateRunUpdateRunsRestClient.PutAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, data, cancellationToken).ConfigureAwait(false);
                var uri = _hciClusterUpdateRunUpdateRunsRestClient.CreatePutRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new HciArmOperation<HciClusterUpdateRunResource>(Response.FromValue(new HciClusterUpdateRunResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Put Update runs for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="data"> Properties of the updateRuns object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<HciClusterUpdateRunResource> CreateOrUpdate(WaitUntil waitUntil, string updateRunName, HciClusterUpdateRunData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _hciClusterUpdateRunUpdateRunsRestClient.Put(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, data, cancellationToken);
                var uri = _hciClusterUpdateRunUpdateRunsRestClient.CreatePutRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new HciArmOperation<HciClusterUpdateRunResource>(Response.FromValue(new HciClusterUpdateRunResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Update run for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual async Task<Response<HciClusterUpdateRunResource>> GetAsync(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.Get");
            scope.Start();
            try
            {
                var response = await _hciClusterUpdateRunUpdateRunsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciClusterUpdateRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Update run for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual Response<HciClusterUpdateRunResource> Get(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.Get");
            scope.Start();
            try
            {
                var response = _hciClusterUpdateRunUpdateRunsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciClusterUpdateRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List all Update runs for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="HciClusterUpdateRunResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<HciClusterUpdateRunResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hciClusterUpdateRunUpdateRunsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hciClusterUpdateRunUpdateRunsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new HciClusterUpdateRunResource(Client, HciClusterUpdateRunData.DeserializeHciClusterUpdateRunData(e)), _hciClusterUpdateRunUpdateRunsClientDiagnostics, Pipeline, "HciClusterUpdateRunCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List all Update runs for a specified update
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="HciClusterUpdateRunResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<HciClusterUpdateRunResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hciClusterUpdateRunUpdateRunsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hciClusterUpdateRunUpdateRunsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new HciClusterUpdateRunResource(Client, HciClusterUpdateRunData.DeserializeHciClusterUpdateRunData(e)), _hciClusterUpdateRunUpdateRunsClientDiagnostics, Pipeline, "HciClusterUpdateRunCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.Exists");
            scope.Start();
            try
            {
                var response = await _hciClusterUpdateRunUpdateRunsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual Response<bool> Exists(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.Exists");
            scope.Start();
            try
            {
                var response = _hciClusterUpdateRunUpdateRunsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual async Task<NullableResponse<HciClusterUpdateRunResource>> GetIfExistsAsync(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _hciClusterUpdateRunUpdateRunsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<HciClusterUpdateRunResource>(response.GetRawResponse());
                return Response.FromValue(new HciClusterUpdateRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UpdateRuns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterUpdateRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="updateRunName"> The name of the Update Run. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="updateRunName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="updateRunName"/> is null. </exception>
        public virtual NullableResponse<HciClusterUpdateRunResource> GetIfExists(string updateRunName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(updateRunName, nameof(updateRunName));

            using var scope = _hciClusterUpdateRunUpdateRunsClientDiagnostics.CreateScope("HciClusterUpdateRunCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _hciClusterUpdateRunUpdateRunsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, updateRunName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<HciClusterUpdateRunResource>(response.GetRawResponse());
                return Response.FromValue(new HciClusterUpdateRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<HciClusterUpdateRunResource> IEnumerable<HciClusterUpdateRunResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<HciClusterUpdateRunResource> IAsyncEnumerable<HciClusterUpdateRunResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
