// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    public partial class HciClusterUpdateData : IUtf8JsonSerializable, IJsonModel<HciClusterUpdateData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterUpdateData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterUpdateData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterUpdateData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(InstalledOn))
            {
                writer.WritePropertyName("installedDate"u8);
                writer.WriteStringValue(InstalledOn.Value, "O");
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(MinSbeVersionRequired))
            {
                writer.WritePropertyName("minSbeVersionRequired"u8);
                writer.WriteStringValue(MinSbeVersionRequired);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Prerequisites))
            {
                writer.WritePropertyName("prerequisites"u8);
                writer.WriteStartArray();
                foreach (var item in Prerequisites)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ComponentVersions))
            {
                writer.WritePropertyName("componentVersions"u8);
                writer.WriteStartArray();
                foreach (var item in ComponentVersions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(RebootRequired))
            {
                writer.WritePropertyName("rebootRequired"u8);
                writer.WriteStringValue(RebootRequired.Value.ToString());
            }
            if (Optional.IsDefined(HealthState))
            {
                writer.WritePropertyName("healthState"u8);
                writer.WriteStringValue(HealthState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(HealthCheckResult))
            {
                writer.WritePropertyName("healthCheckResult"u8);
                writer.WriteStartArray();
                foreach (var item in HealthCheckResult)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HealthCheckOn))
            {
                writer.WritePropertyName("healthCheckDate"u8);
                writer.WriteStringValue(HealthCheckOn.Value, "O");
            }
            if (Optional.IsDefined(PackagePath))
            {
                writer.WritePropertyName("packagePath"u8);
                writer.WriteStringValue(PackagePath);
            }
            if (Optional.IsDefined(PackageSizeInMb))
            {
                writer.WritePropertyName("packageSizeInMb"u8);
                writer.WriteNumberValue(PackageSizeInMb.Value);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (Optional.IsDefined(Publisher))
            {
                writer.WritePropertyName("publisher"u8);
                writer.WriteStringValue(Publisher);
            }
            if (Optional.IsDefined(ReleaseLink))
            {
                writer.WritePropertyName("releaseLink"u8);
                writer.WriteStringValue(ReleaseLink);
            }
            if (Optional.IsDefined(AvailabilityType))
            {
                writer.WritePropertyName("availabilityType"u8);
                writer.WriteStringValue(AvailabilityType.Value.ToString());
            }
            if (Optional.IsDefined(PackageType))
            {
                writer.WritePropertyName("packageType"u8);
                writer.WriteStringValue(PackageType);
            }
            if (Optional.IsDefined(AdditionalProperties))
            {
                writer.WritePropertyName("additionalProperties"u8);
                writer.WriteStringValue(AdditionalProperties);
            }
            writer.WritePropertyName("updateStateProperties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ProgressPercentage))
            {
                writer.WritePropertyName("progressPercentage"u8);
                writer.WriteNumberValue(ProgressPercentage.Value);
            }
            if (Optional.IsDefined(NotifyMessage))
            {
                writer.WritePropertyName("notifyMessage"u8);
                writer.WriteStringValue(NotifyMessage);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        HciClusterUpdateData IJsonModel<HciClusterUpdateData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterUpdateData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterUpdateData(document.RootElement, options);
        }

        internal static HciClusterUpdateData DeserializeHciClusterUpdateData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            HciProvisioningState? provisioningState = default;
            DateTimeOffset? installedDate = default;
            string description = default;
            string minSbeVersionRequired = default;
            HciUpdateState? state = default;
            IList<HciClusterUpdatePrerequisite> prerequisites = default;
            IList<HciPackageVersionInfo> componentVersions = default;
            HciNodeRebootRequirement? rebootRequired = default;
            HciHealthState? healthState = default;
            IList<HciPrecheckResult> healthCheckResult = default;
            DateTimeOffset? healthCheckDate = default;
            string packagePath = default;
            float? packageSizeInMb = default;
            string displayName = default;
            string version = default;
            string publisher = default;
            string releaseLink = default;
            HciAvailabilityType? availabilityType = default;
            string packageType = default;
            string additionalProperties = default;
            float? progressPercentage = default;
            string notifyMessage = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new HciProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("installedDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            installedDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("minSbeVersionRequired"u8))
                        {
                            minSbeVersionRequired = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new HciUpdateState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("prerequisites"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HciClusterUpdatePrerequisite> array = new List<HciClusterUpdatePrerequisite>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HciClusterUpdatePrerequisite.DeserializeHciClusterUpdatePrerequisite(item, options));
                            }
                            prerequisites = array;
                            continue;
                        }
                        if (property0.NameEquals("componentVersions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HciPackageVersionInfo> array = new List<HciPackageVersionInfo>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HciPackageVersionInfo.DeserializeHciPackageVersionInfo(item, options));
                            }
                            componentVersions = array;
                            continue;
                        }
                        if (property0.NameEquals("rebootRequired"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            rebootRequired = new HciNodeRebootRequirement(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("healthState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            healthState = new HciHealthState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("healthCheckResult"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HciPrecheckResult> array = new List<HciPrecheckResult>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HciPrecheckResult.DeserializeHciPrecheckResult(item, options));
                            }
                            healthCheckResult = array;
                            continue;
                        }
                        if (property0.NameEquals("healthCheckDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            healthCheckDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("packagePath"u8))
                        {
                            packagePath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("packageSizeInMb"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            packageSizeInMb = property0.Value.GetSingle();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            displayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("version"u8))
                        {
                            version = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisher"u8))
                        {
                            publisher = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("releaseLink"u8))
                        {
                            releaseLink = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("availabilityType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            availabilityType = new HciAvailabilityType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("packageType"u8))
                        {
                            packageType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("additionalProperties"u8))
                        {
                            additionalProperties = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("updateStateProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("progressPercentage"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    progressPercentage = property1.Value.GetSingle();
                                    continue;
                                }
                                if (property1.NameEquals("notifyMessage"u8))
                                {
                                    notifyMessage = property1.Value.GetString();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterUpdateData(
                id,
                name,
                type,
                systemData,
                location,
                provisioningState,
                installedDate,
                description,
                minSbeVersionRequired,
                state,
                prerequisites ?? new ChangeTrackingList<HciClusterUpdatePrerequisite>(),
                componentVersions ?? new ChangeTrackingList<HciPackageVersionInfo>(),
                rebootRequired,
                healthState,
                healthCheckResult ?? new ChangeTrackingList<HciPrecheckResult>(),
                healthCheckDate,
                packagePath,
                packageSizeInMb,
                displayName,
                version,
                publisher,
                releaseLink,
                availabilityType,
                packageType,
                additionalProperties,
                progressPercentage,
                notifyMessage,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Location))
                {
                    builder.Append("  location: ");
                    builder.AppendLine($"'{Location.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstalledOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    installedDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InstalledOn))
                {
                    builder.Append("    installedDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(InstalledOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Description), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    description: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Description))
                {
                    builder.Append("    description: ");
                    if (Description.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Description}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Description}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinSbeVersionRequired), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    minSbeVersionRequired: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinSbeVersionRequired))
                {
                    builder.Append("    minSbeVersionRequired: ");
                    if (MinSbeVersionRequired.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MinSbeVersionRequired}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MinSbeVersionRequired}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("    state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Prerequisites), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    prerequisites: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Prerequisites))
                {
                    if (Prerequisites.Any())
                    {
                        builder.Append("    prerequisites: ");
                        builder.AppendLine("[");
                        foreach (var item in Prerequisites)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    prerequisites: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComponentVersions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    componentVersions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ComponentVersions))
                {
                    if (ComponentVersions.Any())
                    {
                        builder.Append("    componentVersions: ");
                        builder.AppendLine("[");
                        foreach (var item in ComponentVersions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    componentVersions: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RebootRequired), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    rebootRequired: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RebootRequired))
                {
                    builder.Append("    rebootRequired: ");
                    builder.AppendLine($"'{RebootRequired.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HealthState))
                {
                    builder.Append("    healthState: ");
                    builder.AppendLine($"'{HealthState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthCheckResult), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthCheckResult: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(HealthCheckResult))
                {
                    if (HealthCheckResult.Any())
                    {
                        builder.Append("    healthCheckResult: ");
                        builder.AppendLine("[");
                        foreach (var item in HealthCheckResult)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    healthCheckResult: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HealthCheckOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    healthCheckDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HealthCheckOn))
                {
                    builder.Append("    healthCheckDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(HealthCheckOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PackagePath), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    packagePath: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PackagePath))
                {
                    builder.Append("    packagePath: ");
                    if (PackagePath.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PackagePath}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PackagePath}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PackageSizeInMb), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    packageSizeInMb: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PackageSizeInMb))
                {
                    builder.Append("    packageSizeInMb: ");
                    builder.AppendLine($"'{PackageSizeInMb.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("    displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Version), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    version: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Version))
                {
                    builder.Append("    version: ");
                    if (Version.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Version}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Version}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Publisher), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publisher: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Publisher))
                {
                    builder.Append("    publisher: ");
                    if (Publisher.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Publisher}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Publisher}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReleaseLink), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    releaseLink: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ReleaseLink))
                {
                    builder.Append("    releaseLink: ");
                    if (ReleaseLink.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ReleaseLink}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ReleaseLink}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AvailabilityType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    availabilityType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AvailabilityType))
                {
                    builder.Append("    availabilityType: ");
                    builder.AppendLine($"'{AvailabilityType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PackageType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    packageType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PackageType))
                {
                    builder.Append("    packageType: ");
                    if (PackageType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PackageType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PackageType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdditionalProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    additionalProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdditionalProperties))
                {
                    builder.Append("    additionalProperties: ");
                    if (AdditionalProperties.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AdditionalProperties}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AdditionalProperties}'");
                    }
                }
            }

            builder.Append("    updateStateProperties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProgressPercentage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      progressPercentage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProgressPercentage))
                {
                    builder.Append("      progressPercentage: ");
                    builder.AppendLine($"'{ProgressPercentage.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NotifyMessage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      notifyMessage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NotifyMessage))
                {
                    builder.Append("      notifyMessage: ");
                    if (NotifyMessage.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NotifyMessage}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NotifyMessage}'");
                    }
                }
            }

            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterUpdateData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterUpdateData)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterUpdateData IPersistableModel<HciClusterUpdateData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterUpdateData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterUpdateData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterUpdateData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterUpdateData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
