// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A class representing a collection of <see cref="HciClusterSecuritySettingResource"/> and their operations.
    /// Each <see cref="HciClusterSecuritySettingResource"/> in the collection will belong to the same instance of <see cref="HciClusterResource"/>.
    /// To get a <see cref="HciClusterSecuritySettingCollection"/> instance call the GetHciClusterSecuritySettings method from an instance of <see cref="HciClusterResource"/>.
    /// </summary>
    public partial class HciClusterSecuritySettingCollection : ArmCollection, IEnumerable<HciClusterSecuritySettingResource>, IAsyncEnumerable<HciClusterSecuritySettingResource>
    {
        private readonly ClientDiagnostics _hciClusterSecuritySettingSecuritySettingsClientDiagnostics;
        private readonly SecuritySettingsRestOperations _hciClusterSecuritySettingSecuritySettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="HciClusterSecuritySettingCollection"/> class for mocking. </summary>
        protected HciClusterSecuritySettingCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="HciClusterSecuritySettingCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal HciClusterSecuritySettingCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _hciClusterSecuritySettingSecuritySettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Hci", HciClusterSecuritySettingResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(HciClusterSecuritySettingResource.ResourceType, out string hciClusterSecuritySettingSecuritySettingsApiVersion);
            _hciClusterSecuritySettingSecuritySettingsRestClient = new SecuritySettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, hciClusterSecuritySettingSecuritySettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != HciClusterResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, HciClusterResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a security setting
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<HciClusterSecuritySettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string securitySettingsName, HciClusterSecuritySettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _hciClusterSecuritySettingSecuritySettingsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HciArmOperation<HciClusterSecuritySettingResource>(new HciClusterSecuritySettingOperationSource(Client), _hciClusterSecuritySettingSecuritySettingsClientDiagnostics, Pipeline, _hciClusterSecuritySettingSecuritySettingsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a security setting
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<HciClusterSecuritySettingResource> CreateOrUpdate(WaitUntil waitUntil, string securitySettingsName, HciClusterSecuritySettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _hciClusterSecuritySettingSecuritySettingsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, data, cancellationToken);
                var operation = new HciArmOperation<HciClusterSecuritySettingResource>(new HciClusterSecuritySettingOperationSource(Client), _hciClusterSecuritySettingSecuritySettingsClientDiagnostics, Pipeline, _hciClusterSecuritySettingSecuritySettingsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a SecuritySetting
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual async Task<Response<HciClusterSecuritySettingResource>> GetAsync(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.Get");
            scope.Start();
            try
            {
                var response = await _hciClusterSecuritySettingSecuritySettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciClusterSecuritySettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a SecuritySetting
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual Response<HciClusterSecuritySettingResource> Get(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.Get");
            scope.Start();
            try
            {
                var response = _hciClusterSecuritySettingSecuritySettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HciClusterSecuritySettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List SecuritySetting resources by Clusters
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_ListByClusters</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="HciClusterSecuritySettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<HciClusterSecuritySettingResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hciClusterSecuritySettingSecuritySettingsRestClient.CreateListByClustersRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hciClusterSecuritySettingSecuritySettingsRestClient.CreateListByClustersNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new HciClusterSecuritySettingResource(Client, HciClusterSecuritySettingData.DeserializeHciClusterSecuritySettingData(e)), _hciClusterSecuritySettingSecuritySettingsClientDiagnostics, Pipeline, "HciClusterSecuritySettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List SecuritySetting resources by Clusters
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_ListByClusters</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="HciClusterSecuritySettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<HciClusterSecuritySettingResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hciClusterSecuritySettingSecuritySettingsRestClient.CreateListByClustersRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hciClusterSecuritySettingSecuritySettingsRestClient.CreateListByClustersNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new HciClusterSecuritySettingResource(Client, HciClusterSecuritySettingData.DeserializeHciClusterSecuritySettingData(e)), _hciClusterSecuritySettingSecuritySettingsClientDiagnostics, Pipeline, "HciClusterSecuritySettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.Exists");
            scope.Start();
            try
            {
                var response = await _hciClusterSecuritySettingSecuritySettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual Response<bool> Exists(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.Exists");
            scope.Start();
            try
            {
                var response = _hciClusterSecuritySettingSecuritySettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual async Task<NullableResponse<HciClusterSecuritySettingResource>> GetIfExistsAsync(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _hciClusterSecuritySettingSecuritySettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<HciClusterSecuritySettingResource>(response.GetRawResponse());
                return Response.FromValue(new HciClusterSecuritySettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/securitySettings/{securitySettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecuritySettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciClusterSecuritySettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securitySettingsName"> Name of security setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securitySettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securitySettingsName"/> is null. </exception>
        public virtual NullableResponse<HciClusterSecuritySettingResource> GetIfExists(string securitySettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securitySettingsName, nameof(securitySettingsName));

            using var scope = _hciClusterSecuritySettingSecuritySettingsClientDiagnostics.CreateScope("HciClusterSecuritySettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _hciClusterSecuritySettingSecuritySettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, securitySettingsName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<HciClusterSecuritySettingResource>(response.GetRawResponse());
                return Response.FromValue(new HciClusterSecuritySettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<HciClusterSecuritySettingResource> IEnumerable<HciClusterSecuritySettingResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<HciClusterSecuritySettingResource> IAsyncEnumerable<HciClusterSecuritySettingResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
