// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    /// <summary>
    /// A class representing the HciCluster data model.
    /// Cluster details.
    /// </summary>
    public partial class HciClusterData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterData"/>. </summary>
        /// <param name="location"> The location. </param>
        public HciClusterData(AzureLocation location) : base(location)
        {
            UserAssignedIdentities = new ChangeTrackingDictionary<string, UserAssignedIdentity>();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="status"> Status of the cluster agent. </param>
        /// <param name="connectivityStatus"> Overall connectivity status for the cluster resource. </param>
        /// <param name="cloudId"> Unique, immutable resource id. </param>
        /// <param name="cloudManagementEndpoint"> Endpoint configured for management from the Azure portal. </param>
        /// <param name="aadClientId"> App id of cluster AAD identity. </param>
        /// <param name="aadTenantId"> Tenant id of cluster AAD identity. </param>
        /// <param name="aadApplicationObjectId"> Object id of cluster AAD identity. </param>
        /// <param name="aadServicePrincipalObjectId"> Id of cluster identity service principal. </param>
        /// <param name="softwareAssuranceProperties"> Software Assurance properties of the cluster. </param>
        /// <param name="logCollectionProperties"> Log Collection properties of the cluster. </param>
        /// <param name="remoteSupportProperties"> RemoteSupport properties of the cluster. </param>
        /// <param name="desiredProperties"> Desired properties of the cluster. </param>
        /// <param name="reportedProperties"> Properties reported by cluster agent. </param>
        /// <param name="isolatedVmAttestationConfiguration"> Attestation configurations for isolated VM (e.g. TVM, CVM) of the cluster. </param>
        /// <param name="trialDaysRemaining"> Number of days remaining in the trial period. </param>
        /// <param name="billingModel"> Type of billing applied to the resource. </param>
        /// <param name="registrationTimestamp"> First cluster sync timestamp. </param>
        /// <param name="lastSyncTimestamp"> Most recent cluster sync timestamp. </param>
        /// <param name="lastBillingTimestamp"> Most recent billing meter timestamp. </param>
        /// <param name="serviceEndpoint"> Region specific DataPath Endpoint of the cluster. </param>
        /// <param name="resourceProviderObjectId"> Object id of RP Service Principal. </param>
        /// <param name="principalId"> The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity. </param>
        /// <param name="tenantId"> The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity. </param>
        /// <param name="typeIdentityType"> Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed). </param>
        /// <param name="userAssignedIdentities"> The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, HciProvisioningState? provisioningState, HciClusterStatus? status, HciClusterConnectivityStatus? connectivityStatus, Guid? cloudId, string cloudManagementEndpoint, Guid? aadClientId, Guid? aadTenantId, Guid? aadApplicationObjectId, Guid? aadServicePrincipalObjectId, SoftwareAssuranceProperties softwareAssuranceProperties, LogCollectionProperties logCollectionProperties, RemoteSupportProperties remoteSupportProperties, HciClusterDesiredProperties desiredProperties, HciClusterReportedProperties reportedProperties, IsolatedVmAttestationConfiguration isolatedVmAttestationConfiguration, float? trialDaysRemaining, string billingModel, DateTimeOffset? registrationTimestamp, DateTimeOffset? lastSyncTimestamp, DateTimeOffset? lastBillingTimestamp, string serviceEndpoint, string resourceProviderObjectId, Guid? principalId, Guid? tenantId, HciManagedServiceIdentityType? typeIdentityType, IDictionary<string, UserAssignedIdentity> userAssignedIdentities, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ProvisioningState = provisioningState;
            Status = status;
            ConnectivityStatus = connectivityStatus;
            CloudId = cloudId;
            CloudManagementEndpoint = cloudManagementEndpoint;
            AadClientId = aadClientId;
            AadTenantId = aadTenantId;
            AadApplicationObjectId = aadApplicationObjectId;
            AadServicePrincipalObjectId = aadServicePrincipalObjectId;
            SoftwareAssuranceProperties = softwareAssuranceProperties;
            LogCollectionProperties = logCollectionProperties;
            RemoteSupportProperties = remoteSupportProperties;
            DesiredProperties = desiredProperties;
            ReportedProperties = reportedProperties;
            IsolatedVmAttestationConfiguration = isolatedVmAttestationConfiguration;
            TrialDaysRemaining = trialDaysRemaining;
            BillingModel = billingModel;
            RegistrationTimestamp = registrationTimestamp;
            LastSyncTimestamp = lastSyncTimestamp;
            LastBillingTimestamp = lastBillingTimestamp;
            ServiceEndpoint = serviceEndpoint;
            ResourceProviderObjectId = resourceProviderObjectId;
            PrincipalId = principalId;
            TenantId = tenantId;
            TypeIdentityType = typeIdentityType;
            UserAssignedIdentities = userAssignedIdentities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterData"/> for deserialization. </summary>
        internal HciClusterData()
        {
        }

        /// <summary> Provisioning state. </summary>
        [WirePath("properties.provisioningState")]
        public HciProvisioningState? ProvisioningState { get; }
        /// <summary> Status of the cluster agent. </summary>
        [WirePath("properties.status")]
        public HciClusterStatus? Status { get; }
        /// <summary> Overall connectivity status for the cluster resource. </summary>
        [WirePath("properties.connectivityStatus")]
        public HciClusterConnectivityStatus? ConnectivityStatus { get; }
        /// <summary> Unique, immutable resource id. </summary>
        [WirePath("properties.cloudId")]
        public Guid? CloudId { get; }
        /// <summary> Endpoint configured for management from the Azure portal. </summary>
        [WirePath("properties.cloudManagementEndpoint")]
        public string CloudManagementEndpoint { get; set; }
        /// <summary> App id of cluster AAD identity. </summary>
        [WirePath("properties.aadClientId")]
        public Guid? AadClientId { get; set; }
        /// <summary> Tenant id of cluster AAD identity. </summary>
        [WirePath("properties.aadTenantId")]
        public Guid? AadTenantId { get; set; }
        /// <summary> Object id of cluster AAD identity. </summary>
        [WirePath("properties.aadApplicationObjectId")]
        public Guid? AadApplicationObjectId { get; set; }
        /// <summary> Id of cluster identity service principal. </summary>
        [WirePath("properties.aadServicePrincipalObjectId")]
        public Guid? AadServicePrincipalObjectId { get; set; }
        /// <summary> Software Assurance properties of the cluster. </summary>
        [WirePath("properties.softwareAssuranceProperties")]
        public SoftwareAssuranceProperties SoftwareAssuranceProperties { get; set; }
        /// <summary> Log Collection properties of the cluster. </summary>
        [WirePath("properties.logCollectionProperties")]
        public LogCollectionProperties LogCollectionProperties { get; set; }
        /// <summary> RemoteSupport properties of the cluster. </summary>
        [WirePath("properties.remoteSupportProperties")]
        public RemoteSupportProperties RemoteSupportProperties { get; set; }
        /// <summary> Desired properties of the cluster. </summary>
        [WirePath("properties.desiredProperties")]
        public HciClusterDesiredProperties DesiredProperties { get; set; }
        /// <summary> Properties reported by cluster agent. </summary>
        [WirePath("properties.reportedProperties")]
        public HciClusterReportedProperties ReportedProperties { get; }
        /// <summary> Attestation configurations for isolated VM (e.g. TVM, CVM) of the cluster. </summary>
        [WirePath("properties.isolatedVmAttestationConfiguration")]
        public IsolatedVmAttestationConfiguration IsolatedVmAttestationConfiguration { get; }
        /// <summary> Number of days remaining in the trial period. </summary>
        [WirePath("properties.trialDaysRemaining")]
        public float? TrialDaysRemaining { get; }
        /// <summary> Type of billing applied to the resource. </summary>
        [WirePath("properties.billingModel")]
        public string BillingModel { get; }
        /// <summary> First cluster sync timestamp. </summary>
        [WirePath("properties.registrationTimestamp")]
        public DateTimeOffset? RegistrationTimestamp { get; }
        /// <summary> Most recent cluster sync timestamp. </summary>
        [WirePath("properties.lastSyncTimestamp")]
        public DateTimeOffset? LastSyncTimestamp { get; }
        /// <summary> Most recent billing meter timestamp. </summary>
        [WirePath("properties.lastBillingTimestamp")]
        public DateTimeOffset? LastBillingTimestamp { get; }
        /// <summary> Region specific DataPath Endpoint of the cluster. </summary>
        [WirePath("properties.serviceEndpoint")]
        public string ServiceEndpoint { get; }
        /// <summary> Object id of RP Service Principal. </summary>
        [WirePath("properties.resourceProviderObjectId")]
        public string ResourceProviderObjectId { get; }
        /// <summary> The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity. </summary>
        [WirePath("identity.principalId")]
        public Guid? PrincipalId { get; }
        /// <summary> The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity. </summary>
        [WirePath("identity.tenantId")]
        public Guid? TenantId { get; }
        /// <summary> Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed). </summary>
        [WirePath("identity.type")]
        public HciManagedServiceIdentityType? TypeIdentityType { get; set; }
        /// <summary> The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests. </summary>
        [WirePath("identity.userAssignedIdentities")]
        public IDictionary<string, UserAssignedIdentity> UserAssignedIdentities { get; }
    }
}
