// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Hci.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Hci
{
    public partial class HciClusterData : IUtf8JsonSerializable, IJsonModel<HciClusterData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectivityStatus))
            {
                writer.WritePropertyName("connectivityStatus"u8);
                writer.WriteStringValue(ConnectivityStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CloudId))
            {
                writer.WritePropertyName("cloudId"u8);
                writer.WriteStringValue(CloudId.Value);
            }
            if (Optional.IsDefined(CloudManagementEndpoint))
            {
                writer.WritePropertyName("cloudManagementEndpoint"u8);
                writer.WriteStringValue(CloudManagementEndpoint);
            }
            if (Optional.IsDefined(AadClientId))
            {
                writer.WritePropertyName("aadClientId"u8);
                writer.WriteStringValue(AadClientId.Value);
            }
            if (Optional.IsDefined(AadTenantId))
            {
                writer.WritePropertyName("aadTenantId"u8);
                writer.WriteStringValue(AadTenantId.Value);
            }
            if (Optional.IsDefined(AadApplicationObjectId))
            {
                writer.WritePropertyName("aadApplicationObjectId"u8);
                writer.WriteStringValue(AadApplicationObjectId.Value);
            }
            if (Optional.IsDefined(AadServicePrincipalObjectId))
            {
                writer.WritePropertyName("aadServicePrincipalObjectId"u8);
                writer.WriteStringValue(AadServicePrincipalObjectId.Value);
            }
            if (Optional.IsDefined(SoftwareAssuranceProperties))
            {
                writer.WritePropertyName("softwareAssuranceProperties"u8);
                writer.WriteObjectValue(SoftwareAssuranceProperties, options);
            }
            if (Optional.IsDefined(LogCollectionProperties))
            {
                writer.WritePropertyName("logCollectionProperties"u8);
                writer.WriteObjectValue(LogCollectionProperties, options);
            }
            if (Optional.IsDefined(RemoteSupportProperties))
            {
                writer.WritePropertyName("remoteSupportProperties"u8);
                writer.WriteObjectValue(RemoteSupportProperties, options);
            }
            if (Optional.IsDefined(DesiredProperties))
            {
                writer.WritePropertyName("desiredProperties"u8);
                writer.WriteObjectValue(DesiredProperties, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ReportedProperties))
            {
                writer.WritePropertyName("reportedProperties"u8);
                writer.WriteObjectValue(ReportedProperties, options);
            }
            if (options.Format != "W" && Optional.IsDefined(IsolatedVmAttestationConfiguration))
            {
                writer.WritePropertyName("isolatedVmAttestationConfiguration"u8);
                writer.WriteObjectValue(IsolatedVmAttestationConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(TrialDaysRemaining))
            {
                writer.WritePropertyName("trialDaysRemaining"u8);
                writer.WriteNumberValue(TrialDaysRemaining.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingModel))
            {
                writer.WritePropertyName("billingModel"u8);
                writer.WriteStringValue(BillingModel);
            }
            if (options.Format != "W" && Optional.IsDefined(RegistrationTimestamp))
            {
                writer.WritePropertyName("registrationTimestamp"u8);
                writer.WriteStringValue(RegistrationTimestamp.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastSyncTimestamp))
            {
                writer.WritePropertyName("lastSyncTimestamp"u8);
                writer.WriteStringValue(LastSyncTimestamp.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastBillingTimestamp))
            {
                writer.WritePropertyName("lastBillingTimestamp"u8);
                writer.WriteStringValue(LastBillingTimestamp.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ServiceEndpoint))
            {
                writer.WritePropertyName("serviceEndpoint"u8);
                writer.WriteStringValue(ServiceEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceProviderObjectId))
            {
                writer.WritePropertyName("resourceProviderObjectId"u8);
                writer.WriteStringValue(ResourceProviderObjectId);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("identity"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(PrincipalId))
            {
                writer.WritePropertyName("principalId"u8);
                writer.WriteStringValue(PrincipalId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (Optional.IsDefined(TypeIdentityType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(TypeIdentityType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(UserAssignedIdentities))
            {
                writer.WritePropertyName("userAssignedIdentities"u8);
                writer.WriteStartObject();
                foreach (var item in UserAssignedIdentities)
                {
                    writer.WritePropertyName(item.Key);
                    JsonSerializer.Serialize(writer, item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WriteEndObject();
        }

        HciClusterData IJsonModel<HciClusterData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterData(document.RootElement, options);
        }

        internal static HciClusterData DeserializeHciClusterData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            HciProvisioningState? provisioningState = default;
            HciClusterStatus? status = default;
            HciClusterConnectivityStatus? connectivityStatus = default;
            Guid? cloudId = default;
            string cloudManagementEndpoint = default;
            Guid? aadClientId = default;
            Guid? aadTenantId = default;
            Guid? aadApplicationObjectId = default;
            Guid? aadServicePrincipalObjectId = default;
            SoftwareAssuranceProperties softwareAssuranceProperties = default;
            LogCollectionProperties logCollectionProperties = default;
            RemoteSupportProperties remoteSupportProperties = default;
            HciClusterDesiredProperties desiredProperties = default;
            HciClusterReportedProperties reportedProperties = default;
            IsolatedVmAttestationConfiguration isolatedVmAttestationConfiguration = default;
            float? trialDaysRemaining = default;
            string billingModel = default;
            DateTimeOffset? registrationTimestamp = default;
            DateTimeOffset? lastSyncTimestamp = default;
            DateTimeOffset? lastBillingTimestamp = default;
            string serviceEndpoint = default;
            string resourceProviderObjectId = default;
            Guid? principalId = default;
            Guid? tenantId = default;
            HciManagedServiceIdentityType? type0 = default;
            IDictionary<string, UserAssignedIdentity> userAssignedIdentities = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new HciProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            status = new HciClusterStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("connectivityStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectivityStatus = new HciClusterConnectivityStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("cloudId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            cloudId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("cloudManagementEndpoint"u8))
                        {
                            cloudManagementEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("aadClientId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aadClientId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("aadTenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aadTenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("aadApplicationObjectId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aadApplicationObjectId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("aadServicePrincipalObjectId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aadServicePrincipalObjectId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("softwareAssuranceProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            softwareAssuranceProperties = SoftwareAssuranceProperties.DeserializeSoftwareAssuranceProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("logCollectionProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            logCollectionProperties = LogCollectionProperties.DeserializeLogCollectionProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("remoteSupportProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteSupportProperties = RemoteSupportProperties.DeserializeRemoteSupportProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("desiredProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            desiredProperties = HciClusterDesiredProperties.DeserializeHciClusterDesiredProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("reportedProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            reportedProperties = HciClusterReportedProperties.DeserializeHciClusterReportedProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("isolatedVmAttestationConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isolatedVmAttestationConfiguration = IsolatedVmAttestationConfiguration.DeserializeIsolatedVmAttestationConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("trialDaysRemaining"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            trialDaysRemaining = property0.Value.GetSingle();
                            continue;
                        }
                        if (property0.NameEquals("billingModel"u8))
                        {
                            billingModel = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("registrationTimestamp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            registrationTimestamp = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastSyncTimestamp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastSyncTimestamp = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastBillingTimestamp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastBillingTimestamp = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("serviceEndpoint"u8))
                        {
                            serviceEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceProviderObjectId"u8))
                        {
                            resourceProviderObjectId = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("principalId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            principalId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("type"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            type0 = new HciManagedServiceIdentityType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("userAssignedIdentities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, UserAssignedIdentity> dictionary = new Dictionary<string, UserAssignedIdentity>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, JsonSerializer.Deserialize<UserAssignedIdentity>(property1.Value.GetRawText()));
                            }
                            userAssignedIdentities = dictionary;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                provisioningState,
                status,
                connectivityStatus,
                cloudId,
                cloudManagementEndpoint,
                aadClientId,
                aadTenantId,
                aadApplicationObjectId,
                aadServicePrincipalObjectId,
                softwareAssuranceProperties,
                logCollectionProperties,
                remoteSupportProperties,
                desiredProperties,
                reportedProperties,
                isolatedVmAttestationConfiguration,
                trialDaysRemaining,
                billingModel,
                registrationTimestamp,
                lastSyncTimestamp,
                lastBillingTimestamp,
                serviceEndpoint,
                resourceProviderObjectId,
                principalId,
                tenantId,
                type0,
                userAssignedIdentities ?? new ChangeTrackingDictionary<string, UserAssignedIdentity>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("    status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectivityStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    connectivityStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectivityStatus))
                {
                    builder.Append("    connectivityStatus: ");
                    builder.AppendLine($"'{ConnectivityStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CloudId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    cloudId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CloudId))
                {
                    builder.Append("    cloudId: ");
                    builder.AppendLine($"'{CloudId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CloudManagementEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    cloudManagementEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CloudManagementEndpoint))
                {
                    builder.Append("    cloudManagementEndpoint: ");
                    if (CloudManagementEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CloudManagementEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CloudManagementEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadClientId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    aadClientId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadClientId))
                {
                    builder.Append("    aadClientId: ");
                    builder.AppendLine($"'{AadClientId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    aadTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadTenantId))
                {
                    builder.Append("    aadTenantId: ");
                    builder.AppendLine($"'{AadTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadApplicationObjectId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    aadApplicationObjectId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadApplicationObjectId))
                {
                    builder.Append("    aadApplicationObjectId: ");
                    builder.AppendLine($"'{AadApplicationObjectId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadServicePrincipalObjectId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    aadServicePrincipalObjectId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadServicePrincipalObjectId))
                {
                    builder.Append("    aadServicePrincipalObjectId: ");
                    builder.AppendLine($"'{AadServicePrincipalObjectId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SoftwareAssuranceProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    softwareAssuranceProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SoftwareAssuranceProperties))
                {
                    builder.Append("    softwareAssuranceProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SoftwareAssuranceProperties, options, 4, false, "    softwareAssuranceProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogCollectionProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    logCollectionProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LogCollectionProperties))
                {
                    builder.Append("    logCollectionProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LogCollectionProperties, options, 4, false, "    logCollectionProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RemoteSupportProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    remoteSupportProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RemoteSupportProperties))
                {
                    builder.Append("    remoteSupportProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RemoteSupportProperties, options, 4, false, "    remoteSupportProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DesiredProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    desiredProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DesiredProperties))
                {
                    builder.Append("    desiredProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DesiredProperties, options, 4, false, "    desiredProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReportedProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    reportedProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ReportedProperties))
                {
                    builder.Append("    reportedProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ReportedProperties, options, 4, false, "    reportedProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsolatedVmAttestationConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isolatedVmAttestationConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsolatedVmAttestationConfiguration))
                {
                    builder.Append("    isolatedVmAttestationConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, IsolatedVmAttestationConfiguration, options, 4, false, "    isolatedVmAttestationConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TrialDaysRemaining), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    trialDaysRemaining: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TrialDaysRemaining))
                {
                    builder.Append("    trialDaysRemaining: ");
                    builder.AppendLine($"'{TrialDaysRemaining.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingModel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    billingModel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingModel))
                {
                    builder.Append("    billingModel: ");
                    if (BillingModel.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingModel}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingModel}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RegistrationTimestamp), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    registrationTimestamp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RegistrationTimestamp))
                {
                    builder.Append("    registrationTimestamp: ");
                    var formattedDateTimeString = TypeFormatters.ToString(RegistrationTimestamp.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastSyncTimestamp), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastSyncTimestamp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastSyncTimestamp))
                {
                    builder.Append("    lastSyncTimestamp: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastSyncTimestamp.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastBillingTimestamp), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastBillingTimestamp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastBillingTimestamp))
                {
                    builder.Append("    lastBillingTimestamp: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastBillingTimestamp.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    serviceEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServiceEndpoint))
                {
                    builder.Append("    serviceEndpoint: ");
                    if (ServiceEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ServiceEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ServiceEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceProviderObjectId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceProviderObjectId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceProviderObjectId))
                {
                    builder.Append("    resourceProviderObjectId: ");
                    if (ResourceProviderObjectId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ResourceProviderObjectId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ResourceProviderObjectId}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.Append("  identity:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    principalId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalId))
                {
                    builder.Append("    principalId: ");
                    builder.AppendLine($"'{PrincipalId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    tenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TenantId))
                {
                    builder.Append("    tenantId: ");
                    builder.AppendLine($"'{TenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TypeIdentityType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TypeIdentityType))
                {
                    builder.Append("    type: ");
                    builder.AppendLine($"'{TypeIdentityType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserAssignedIdentities), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userAssignedIdentities: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(UserAssignedIdentities))
                {
                    if (UserAssignedIdentities.Any())
                    {
                        builder.Append("    userAssignedIdentities: ");
                        builder.AppendLine("{");
                        foreach (var item in UserAssignedIdentities)
                        {
                            builder.Append($"        '{item.Key}': ");
                            BicepSerializationHelpers.AppendChildObject(builder, item.Value, options, 6, false, "    userAssignedIdentities: ");
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterData)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterData IPersistableModel<HciClusterData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
