// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableHciArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableHciArmClient"/> class for mocking. </summary>
        protected MockableHciArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableHciArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableHciArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableHciArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of HciEdgeDeviceResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of HciEdgeDeviceResources and their operations over a HciEdgeDeviceResource. </returns>
        public virtual HciEdgeDeviceCollection GetHciEdgeDevices(ResourceIdentifier scope)
        {
            return new HciEdgeDeviceCollection(Client, scope);
        }

        /// <summary>
        /// Get a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="edgeDeviceName"> Name of Device. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="edgeDeviceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="edgeDeviceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<HciEdgeDeviceResource>> GetHciEdgeDeviceAsync(ResourceIdentifier scope, string edgeDeviceName, CancellationToken cancellationToken = default)
        {
            return await GetHciEdgeDevices(scope).GetAsync(edgeDeviceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a EdgeDevice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EdgeDevices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HciEdgeDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="edgeDeviceName"> Name of Device. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="edgeDeviceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="edgeDeviceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<HciEdgeDeviceResource> GetHciEdgeDevice(ResourceIdentifier scope, string edgeDeviceName, CancellationToken cancellationToken = default)
        {
            return GetHciEdgeDevices(scope).Get(edgeDeviceName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ArcSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ArcSettingResource.CreateResourceIdentifier" /> to create an <see cref="ArcSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ArcSettingResource"/> object. </returns>
        public virtual ArcSettingResource GetArcSettingResource(ResourceIdentifier id)
        {
            ArcSettingResource.ValidateResourceId(id);
            return new ArcSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterResource"/> object. </returns>
        public virtual HciClusterResource GetHciClusterResource(ResourceIdentifier id)
        {
            HciClusterResource.ValidateResourceId(id);
            return new HciClusterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterDeploymentSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterDeploymentSettingResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterDeploymentSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterDeploymentSettingResource"/> object. </returns>
        public virtual HciClusterDeploymentSettingResource GetHciClusterDeploymentSettingResource(ResourceIdentifier id)
        {
            HciClusterDeploymentSettingResource.ValidateResourceId(id);
            return new HciClusterDeploymentSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciEdgeDeviceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciEdgeDeviceResource.CreateResourceIdentifier" /> to create a <see cref="HciEdgeDeviceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciEdgeDeviceResource"/> object. </returns>
        public virtual HciEdgeDeviceResource GetHciEdgeDeviceResource(ResourceIdentifier id)
        {
            HciEdgeDeviceResource.ValidateResourceId(id);
            return new HciEdgeDeviceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ArcExtensionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ArcExtensionResource.CreateResourceIdentifier" /> to create an <see cref="ArcExtensionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ArcExtensionResource"/> object. </returns>
        public virtual ArcExtensionResource GetArcExtensionResource(ResourceIdentifier id)
        {
            ArcExtensionResource.ValidateResourceId(id);
            return new ArcExtensionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterOfferResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterOfferResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterOfferResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterOfferResource"/> object. </returns>
        public virtual HciClusterOfferResource GetHciClusterOfferResource(ResourceIdentifier id)
        {
            HciClusterOfferResource.ValidateResourceId(id);
            return new HciClusterOfferResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterPublisherResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterPublisherResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterPublisherResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterPublisherResource"/> object. </returns>
        public virtual HciClusterPublisherResource GetHciClusterPublisherResource(ResourceIdentifier id)
        {
            HciClusterPublisherResource.ValidateResourceId(id);
            return new HciClusterPublisherResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterSecuritySettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterSecuritySettingResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterSecuritySettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterSecuritySettingResource"/> object. </returns>
        public virtual HciClusterSecuritySettingResource GetHciClusterSecuritySettingResource(ResourceIdentifier id)
        {
            HciClusterSecuritySettingResource.ValidateResourceId(id);
            return new HciClusterSecuritySettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciSkuResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciSkuResource.CreateResourceIdentifier" /> to create a <see cref="HciSkuResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciSkuResource"/> object. </returns>
        public virtual HciSkuResource GetHciSkuResource(ResourceIdentifier id)
        {
            HciSkuResource.ValidateResourceId(id);
            return new HciSkuResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterUpdateRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterUpdateRunResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterUpdateRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterUpdateRunResource"/> object. </returns>
        public virtual HciClusterUpdateRunResource GetHciClusterUpdateRunResource(ResourceIdentifier id)
        {
            HciClusterUpdateRunResource.ValidateResourceId(id);
            return new HciClusterUpdateRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterUpdateSummaryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterUpdateSummaryResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterUpdateSummaryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterUpdateSummaryResource"/> object. </returns>
        public virtual HciClusterUpdateSummaryResource GetHciClusterUpdateSummaryResource(ResourceIdentifier id)
        {
            HciClusterUpdateSummaryResource.ValidateResourceId(id);
            return new HciClusterUpdateSummaryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HciClusterUpdateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HciClusterUpdateResource.CreateResourceIdentifier" /> to create a <see cref="HciClusterUpdateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HciClusterUpdateResource"/> object. </returns>
        public virtual HciClusterUpdateResource GetHciClusterUpdateResource(ResourceIdentifier id)
        {
            HciClusterUpdateResource.ValidateResourceId(id);
            return new HciClusterUpdateResource(Client, id);
        }
    }
}
