// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Hci.Models;

namespace Azure.ResourceManager.Hci.Samples
{
    public partial class Sample_HciClusterUpdateRunCollection
    {
        // List Update runs under cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListUpdateRunsUnderClusterResource()
        {
            // Generated from example definition: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/ListUpdateRuns.json
            // this example is just showing the usage of "UpdateRuns_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HciClusterUpdateResource created on azure
            // for more information of creating HciClusterUpdateResource, please refer to the document of HciClusterUpdateResource
            string subscriptionId = "b8d594e5-51f3-4c11-9c54-a7771b81c712";
            string resourceGroupName = "testrg";
            string clusterName = "testcluster";
            string updateName = "Microsoft4.2203.2.32";
            ResourceIdentifier hciClusterUpdateResourceId = HciClusterUpdateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, updateName);
            HciClusterUpdateResource hciClusterUpdate = client.GetHciClusterUpdateResource(hciClusterUpdateResourceId);

            // get the collection of this HciClusterUpdateRunResource
            HciClusterUpdateRunCollection collection = hciClusterUpdate.GetHciClusterUpdateRuns();

            // invoke the operation and iterate over the result
            await foreach (HciClusterUpdateRunResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HciClusterUpdateRunData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Update runs under cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_GetUpdateRunsUnderClusterResource()
        {
            // Generated from example definition: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/PutUpdateRuns.json
            // this example is just showing the usage of "UpdateRuns_Put" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HciClusterUpdateResource created on azure
            // for more information of creating HciClusterUpdateResource, please refer to the document of HciClusterUpdateResource
            string subscriptionId = "b8d594e5-51f3-4c11-9c54-a7771b81c712";
            string resourceGroupName = "testrg";
            string clusterName = "testcluster";
            string updateName = "Microsoft4.2203.2.32";
            ResourceIdentifier hciClusterUpdateResourceId = HciClusterUpdateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, updateName);
            HciClusterUpdateResource hciClusterUpdate = client.GetHciClusterUpdateResource(hciClusterUpdateResourceId);

            // get the collection of this HciClusterUpdateRunResource
            HciClusterUpdateRunCollection collection = hciClusterUpdate.GetHciClusterUpdateRuns();

            // invoke the operation
            string updateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3";
            HciClusterUpdateRunData data = new HciClusterUpdateRunData()
            {
                NamePropertiesProgressName = "Unnamed step",
                Description = "Update Azure Stack.",
                ErrorMessage = "",
                Status = "Success",
                StartOn = DateTimeOffset.Parse("2022-04-06T01:36:33.3876751+00:00"),
                EndOn = DateTimeOffset.Parse("2022-04-06T13:58:42.969006+00:00"),
                LastCompletedOn = DateTimeOffset.Parse("2022-04-06T13:58:42.969006+00:00"),
                Steps =
{
new HciUpdateStep()
{
Name = "PreUpdate Cloud",
Description = "Prepare for SSU update",
ErrorMessage = "",
Status = "Success",
StartOn = DateTimeOffset.Parse("2022-04-06T01:36:33.3876751+00:00"),
EndOn = DateTimeOffset.Parse("2022-04-06T01:37:16.8728314+00:00"),
LastUpdatedOn = DateTimeOffset.Parse("2022-04-06T01:37:16.8728314+00:00"),
Steps =
{
},
}
},
            };
            ArmOperation<HciClusterUpdateRunResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, updateRunName, data);
            HciClusterUpdateRunResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HciClusterUpdateRunData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Update runs under cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetUpdateRunsUnderClusterResource()
        {
            // Generated from example definition: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/GetUpdateRuns.json
            // this example is just showing the usage of "UpdateRuns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HciClusterUpdateResource created on azure
            // for more information of creating HciClusterUpdateResource, please refer to the document of HciClusterUpdateResource
            string subscriptionId = "b8d594e5-51f3-4c11-9c54-a7771b81c712";
            string resourceGroupName = "testrg";
            string clusterName = "testcluster";
            string updateName = "Microsoft4.2203.2.32";
            ResourceIdentifier hciClusterUpdateResourceId = HciClusterUpdateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, updateName);
            HciClusterUpdateResource hciClusterUpdate = client.GetHciClusterUpdateResource(hciClusterUpdateResourceId);

            // get the collection of this HciClusterUpdateRunResource
            HciClusterUpdateRunCollection collection = hciClusterUpdate.GetHciClusterUpdateRuns();

            // invoke the operation
            string updateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3";
            HciClusterUpdateRunResource result = await collection.GetAsync(updateRunName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HciClusterUpdateRunData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Update runs under cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetUpdateRunsUnderClusterResource()
        {
            // Generated from example definition: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/GetUpdateRuns.json
            // this example is just showing the usage of "UpdateRuns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HciClusterUpdateResource created on azure
            // for more information of creating HciClusterUpdateResource, please refer to the document of HciClusterUpdateResource
            string subscriptionId = "b8d594e5-51f3-4c11-9c54-a7771b81c712";
            string resourceGroupName = "testrg";
            string clusterName = "testcluster";
            string updateName = "Microsoft4.2203.2.32";
            ResourceIdentifier hciClusterUpdateResourceId = HciClusterUpdateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, updateName);
            HciClusterUpdateResource hciClusterUpdate = client.GetHciClusterUpdateResource(hciClusterUpdateResourceId);

            // get the collection of this HciClusterUpdateRunResource
            HciClusterUpdateRunCollection collection = hciClusterUpdate.GetHciClusterUpdateRuns();

            // invoke the operation
            string updateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3";
            bool result = await collection.ExistsAsync(updateRunName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Update runs under cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetUpdateRunsUnderClusterResource()
        {
            // Generated from example definition: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/GetUpdateRuns.json
            // this example is just showing the usage of "UpdateRuns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HciClusterUpdateResource created on azure
            // for more information of creating HciClusterUpdateResource, please refer to the document of HciClusterUpdateResource
            string subscriptionId = "b8d594e5-51f3-4c11-9c54-a7771b81c712";
            string resourceGroupName = "testrg";
            string clusterName = "testcluster";
            string updateName = "Microsoft4.2203.2.32";
            ResourceIdentifier hciClusterUpdateResourceId = HciClusterUpdateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, updateName);
            HciClusterUpdateResource hciClusterUpdate = client.GetHciClusterUpdateResource(hciClusterUpdateResourceId);

            // get the collection of this HciClusterUpdateRunResource
            HciClusterUpdateRunCollection collection = hciClusterUpdate.GetHciClusterUpdateRuns();

            // invoke the operation
            string updateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3";
            NullableResponse<HciClusterUpdateRunResource> response = await collection.GetIfExistsAsync(updateRunName);
            HciClusterUpdateRunResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HciClusterUpdateRunData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
