# Generated code configuration

Run `dotnet build /t:GenerateCode` to generate code.

``` yaml
azure-arm: true
csharp: true
library-name: LargeInstance
namespace: Azure.ResourceManager.LargeInstance
require: https://github.com/Azure/azure-rest-api-specs/blob/2299e0ee52b170edc9c7b50e1a864501d514692f/specification/azurelargeinstance/resource-manager/readme.md
output-folder: $(this-folder)/Generated
clear-output-folder: true
sample-gen:
  output-folder: $(this-folder)/../samples/Generated
  clear-output-folder: true
skip-csproj: true
modelerfour:
  flatten-payloads: false
use-model-reader-writer: true
use-write-core: true

#mgmt-debug:
#  show-serialized-names: true

rename-mapping:
  AzureLargeStorageInstance: LargeStorageInstance
  AzureLargeInstance: LargeInstance
  AzureLargeInstanceForcePowerState: LargeInstanceForcePowerState
  AzureLargeInstanceHardwareTypeNamesEnum: LargeInstanceHardwareTypeName
  AzureLargeInstanceHardwareTypeNamesEnum.Cisco_UCS: CiscoUcs
  AzureLargeInstanceHardwareTypeNamesEnum.HPE: Hpe
  AzureLargeInstanceHardwareTypeNamesEnum.SDFLEX: SDFlex
  AzureLargeInstancePowerStateEnum: LargeInstancePowerState
  AzureLargeInstanceProvisioningStatesEnum: LargeInstanceProvisioningState
  AzureLargeInstanceSizeNamesEnum: LargeInstanceSizeName
  AzureLargeInstanceSizeNamesEnum.S72m: S72m
  AzureLargeInstanceSizeNamesEnum.S144m: S144m
  AzureLargeInstanceSizeNamesEnum.S192m: S192m
  AzureLargeInstanceSizeNamesEnum.S224m: S224m
  AzureLargeInstanceSizeNamesEnum.S384m: S384m
  AzureLargeInstanceSizeNamesEnum.S448m: S448m
  AzureLargeInstanceSizeNamesEnum.S576m: S576m
  AzureLargeInstanceSizeNamesEnum.S672m: S672m
  AzureLargeInstanceSizeNamesEnum.S768m: S768m
  AzureLargeInstanceSizeNamesEnum.S896m: S896m
  AzureLargeInstanceSizeNamesEnum.S960m: S960m

prepend-rp-prefix:
  - Disk
  - ForceState
  - HardwareProfile
  - IpAddress
  - NetworkProfile
  - OperationStatusResult
  - OsProfile
  - ProvisioningState
  - StorageBillingProperties
  - StorageProfile
  - StorageProperties

format-by-name-rules:
  'tenantId': 'uuid'
  'ETag': 'etag'
  'location': 'azure-location'
  '*Uri': 'Uri'
  '*Uris': 'Uri'

acronym-mapping:
  CPU: Cpu
  CPUs: Cpus
  Os: OS
  Ip: IP
  Ips: IPs|ips
  ID: Id
  IDs: Ids
  VM: Vm
  VMs: Vms
  Vmos: VmOS
  VMScaleSet: VmScaleSet
  DNS: Dns
  VPN: Vpn
  NAT: Nat
  WAN: Wan
  Ipv4: IPv4|ipv4
  Ipv6: IPv6|ipv6
  Ipsec: IPsec|ipsec
  SSO: Sso
  URI: Uri
  Etag: ETag|etag
  Xm: xm
  Xxm: xxm
  Se: se
  Om: om
  Oom: oom
  Oo: oo
  Ooo: ooo

```