// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LargeInstance.Models
{
    /// <summary> Describes the billing related details of the AzureLargeStorageInstance. </summary>
    public partial class LargeInstanceStorageBillingProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LargeInstanceStorageBillingProperties"/>. </summary>
        internal LargeInstanceStorageBillingProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LargeInstanceStorageBillingProperties"/>. </summary>
        /// <param name="billingMode"> the billing mode for the storage instance. </param>
        /// <param name="sku"> the SKU type that is provisioned. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LargeInstanceStorageBillingProperties(string billingMode, string sku, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingMode = billingMode;
            Sku = sku;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the billing mode for the storage instance. </summary>
        public string BillingMode { get; }
        /// <summary> the SKU type that is provisioned. </summary>
        public string Sku { get; }
    }
}
