// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LargeInstance.Models
{
    /// <summary> Enum of available model types (each of which have their own storage / memory sizes) for an Azure Large Instance type. See https://docs.microsoft.com/azure/sap/large-instances/hana-available-skus. </summary>
    public readonly partial struct LargeInstanceSizeName : IEquatable<LargeInstanceSizeName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LargeInstanceSizeName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LargeInstanceSizeName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string S72mValue = "S72m";
        private const string S144mValue = "S144m";
        private const string S72Value = "S72";
        private const string S144Value = "S144";
        private const string S192Value = "S192";
        private const string S192mValue = "S192m";
        private const string S192xmValue = "S192xm";
        private const string S96Value = "S96";
        private const string S112Value = "S112";
        private const string S224Value = "S224";
        private const string S224mValue = "S224m";
        private const string S224omValue = "S224om";
        private const string S224ooValue = "S224oo";
        private const string S224oomValue = "S224oom";
        private const string S224oooValue = "S224ooo";
        private const string S224seValue = "S224se";
        private const string S384Value = "S384";
        private const string S384mValue = "S384m";
        private const string S384xmValue = "S384xm";
        private const string S384xxmValue = "S384xxm";
        private const string S448Value = "S448";
        private const string S448mValue = "S448m";
        private const string S448omValue = "S448om";
        private const string S448ooValue = "S448oo";
        private const string S448oomValue = "S448oom";
        private const string S448oooValue = "S448ooo";
        private const string S448seValue = "S448se";
        private const string S576mValue = "S576m";
        private const string S576xmValue = "S576xm";
        private const string S672Value = "S672";
        private const string S672mValue = "S672m";
        private const string S672omValue = "S672om";
        private const string S672ooValue = "S672oo";
        private const string S672oomValue = "S672oom";
        private const string S672oooValue = "S672ooo";
        private const string S768Value = "S768";
        private const string S768mValue = "S768m";
        private const string S768xmValue = "S768xm";
        private const string S896Value = "S896";
        private const string S896mValue = "S896m";
        private const string S896omValue = "S896om";
        private const string S896ooValue = "S896oo";
        private const string S896oomValue = "S896oom";
        private const string S896oooValue = "S896ooo";
        private const string S960mValue = "S960m";

        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S72m { get; } = new LargeInstanceSizeName(S72mValue);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S144m { get; } = new LargeInstanceSizeName(S144mValue);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S72 { get; } = new LargeInstanceSizeName(S72Value);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S144 { get; } = new LargeInstanceSizeName(S144Value);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S192 { get; } = new LargeInstanceSizeName(S192Value);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S192m { get; } = new LargeInstanceSizeName(S192mValue);
        /// <summary> Type I class SKU that can't be purchased anymore. </summary>
        public static LargeInstanceSizeName S192xm { get; } = new LargeInstanceSizeName(S192xmValue);
        /// <summary> 2 sockets, 96 CPU threads, 48 CPU cores, 768 GB total memory, 768 GB DRAM, 3.0 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S96 { get; } = new LargeInstanceSizeName(S96Value);
        /// <summary> No longer offered or used. </summary>
        public static LargeInstanceSizeName S112 { get; } = new LargeInstanceSizeName(S112Value);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 3 TB total memory, 3 TB DRAM, 6.3 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224 { get; } = new LargeInstanceSizeName(S224Value);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 6 TB total memory, 6 TB DRAM, 10.5 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224m { get; } = new LargeInstanceSizeName(S224mValue);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 6 TB total memory, 3 TB DRAM, 3 TB memory optane, 10.5 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224om { get; } = new LargeInstanceSizeName(S224omValue);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 4.5 TB total memory, 1.5 TB DRAM, 3 TB memory optane, 8.4 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224oo { get; } = new LargeInstanceSizeName(S224ooValue);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 9 TB total memory, 3 TB DRAM, 6 TB memory optane, 14.8 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224oom { get; } = new LargeInstanceSizeName(S224oomValue);
        /// <summary> 4 sockets, 224 CPU threads, 112 CPU cores, 7.5TB total memory, 1.5 TB DRAM, 6 TB memory optane, 12.7 TB storage, Cisco_UCS hardware type. </summary>
        public static LargeInstanceSizeName S224ooo { get; } = new LargeInstanceSizeName(S224oooValue);
        /// <summary> 4 sockets, 448 CPU threads, 6 TB total memory, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S224se { get; } = new LargeInstanceSizeName(S224seValue);
        /// <summary> 8 sockets, 384 CPU threads, 192 CPU cores, 4 TB total memory, 4 TB DRAM, 16 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S384 { get; } = new LargeInstanceSizeName(S384Value);
        /// <summary> 8 sockets, 384 CPU threads, 192 CPU cores, 6 TB total memory, 6 TB DRAM, 18 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S384m { get; } = new LargeInstanceSizeName(S384mValue);
        /// <summary> 8 sockets, 384 CPU threads, 192 CPU cores, 8 TB total memory, 8 TB DRAM, 22 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S384xm { get; } = new LargeInstanceSizeName(S384xmValue);
        /// <summary> 8 sockets, 384 CPU threads, 12 TB total memory, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S384xxm { get; } = new LargeInstanceSizeName(S384xxmValue);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 6 TB total memory, 6 TB DRAM, 10.5 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448 { get; } = new LargeInstanceSizeName(S448Value);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 12 TB total memory, 12 TB DRAM, 18.9 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448m { get; } = new LargeInstanceSizeName(S448mValue);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 12 TB total memory, 6 TB DRAM, 6 TB memory optane, 18.9 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448om { get; } = new LargeInstanceSizeName(S448omValue);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 9 TB total memory, 3 TB DRAM, 6 TB memory optane, 14.8 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448oo { get; } = new LargeInstanceSizeName(S448ooValue);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 18 TB total memory, 6 TB DRAM, 12 memory optane, 27.4 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448oom { get; } = new LargeInstanceSizeName(S448oomValue);
        /// <summary> 8 sockets, 448 CPU threads, 224 CPU cores, 15 TB total memory, 3 TB DRAM, 12 memory optane, 23.2 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448ooo { get; } = new LargeInstanceSizeName(S448oooValue);
        /// <summary> 8 sockets, 448 CPU threads, 12 TB total memory, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S448se { get; } = new LargeInstanceSizeName(S448seValue);
        /// <summary> 12 sockets, 576 CPU threads, 288 CPU cores, 12 TB total memory, 12 TB DRAM, 28 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S576m { get; } = new LargeInstanceSizeName(S576mValue);
        /// <summary> 12 sockets, 576 CPU threads, 288 CPU cores, 18 TB total memory, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S576xm { get; } = new LargeInstanceSizeName(S576xmValue);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 9 TB total memory, 9 TB DRAM, 14.7 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672 { get; } = new LargeInstanceSizeName(S672Value);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 18 TB total memory, 18 TB DRAM, 27.4 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672m { get; } = new LargeInstanceSizeName(S672mValue);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 18 TB total memory, 9 TB DRAM, 9 TB memory optane, 27.4 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672om { get; } = new LargeInstanceSizeName(S672omValue);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 13.5 TB total memory, 4.5 TB DRAM, 9 TB memory optane, 21.1 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672oo { get; } = new LargeInstanceSizeName(S672ooValue);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 27 TB total memory, 9 TB DRAM, 18 TB memory optane, 40 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672oom { get; } = new LargeInstanceSizeName(S672oomValue);
        /// <summary> 12 sockets, 672 CPU threads, 336 CPU cores, 22.5 TB total memory, 4.5 TB DRAM, 18 TB memory optane, 33.7 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S672ooo { get; } = new LargeInstanceSizeName(S672oooValue);
        /// <summary> No longer offered or used. </summary>
        public static LargeInstanceSizeName S768 { get; } = new LargeInstanceSizeName(S768Value);
        /// <summary> 16 sockets, 768 CPU threads, 384 CPU cores, 16 TB total memory, 16 TB DRAM, 36 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S768m { get; } = new LargeInstanceSizeName(S768mValue);
        /// <summary> 16 sockets, 768 CPU threads, 384 CPU cores, 24 TB total memory, 24 TB DRAM, 56 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S768xm { get; } = new LargeInstanceSizeName(S768xmValue);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 12 TB total memory, 12 TB DRAM, 18.9 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896 { get; } = new LargeInstanceSizeName(S896Value);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 24 TB	total memory, 24 TB DRAM, 35.8 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896m { get; } = new LargeInstanceSizeName(S896mValue);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 24 TB	total memory, 12 TB DRAM, 12 TB memory optane, 35.8 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896om { get; } = new LargeInstanceSizeName(S896omValue);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 18 TB  total memory, 6 TB DRAM, 12 TB memory optane, 27.4 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896oo { get; } = new LargeInstanceSizeName(S896ooValue);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 36 TB total memory, 12 TB DRAM, 24 TB memory optane, 52.7 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896oom { get; } = new LargeInstanceSizeName(S896oomValue);
        /// <summary> 16 sockets, 896 CPU threads, 448 CPU cores, 30 TB total memory, 6 TB DRAM, 24 TB memory optane, 44.3 TB storage, SDFLEX hardware type. </summary>
        public static LargeInstanceSizeName S896ooo { get; } = new LargeInstanceSizeName(S896oooValue);
        /// <summary> 20 sockets, 960 CPU threads, 480 CPU cores, 20 TB total memory, 20 TB DRAM, 46 TB storage, HPEMc990x hardware type. </summary>
        public static LargeInstanceSizeName S960m { get; } = new LargeInstanceSizeName(S960mValue);
        /// <summary> Determines if two <see cref="LargeInstanceSizeName"/> values are the same. </summary>
        public static bool operator ==(LargeInstanceSizeName left, LargeInstanceSizeName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LargeInstanceSizeName"/> values are not the same. </summary>
        public static bool operator !=(LargeInstanceSizeName left, LargeInstanceSizeName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LargeInstanceSizeName"/>. </summary>
        public static implicit operator LargeInstanceSizeName(string value) => new LargeInstanceSizeName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LargeInstanceSizeName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LargeInstanceSizeName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
