// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LargeInstance.Models
{
    /// <summary> Provisioning states that an Azure Large Instance can be in. </summary>
    public readonly partial struct LargeInstanceProvisioningState : IEquatable<LargeInstanceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LargeInstanceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LargeInstanceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string MigratingValue = "Migrating";
        private const string CanceledValue = "Canceled";

        /// <summary> Accepted means Azure Large Instance resource provisioning has been accepted. </summary>
        public static LargeInstanceProvisioningState Accepted { get; } = new LargeInstanceProvisioningState(AcceptedValue);
        /// <summary> Creating means Azure Large Instance resource is being created. </summary>
        public static LargeInstanceProvisioningState Creating { get; } = new LargeInstanceProvisioningState(CreatingValue);
        /// <summary> Updating means an existing Azure Large Instance resource is being updated. </summary>
        public static LargeInstanceProvisioningState Updating { get; } = new LargeInstanceProvisioningState(UpdatingValue);
        /// <summary> Failed means Azure Large Instance resource is in failed state. </summary>
        public static LargeInstanceProvisioningState Failed { get; } = new LargeInstanceProvisioningState(FailedValue);
        /// <summary> Succeeded means Azure Large Instance resource creation succeeded during last create/update. </summary>
        public static LargeInstanceProvisioningState Succeeded { get; } = new LargeInstanceProvisioningState(SucceededValue);
        /// <summary> Deleting means Azure Large Instance resource is in the process of being deleted. </summary>
        public static LargeInstanceProvisioningState Deleting { get; } = new LargeInstanceProvisioningState(DeletingValue);
        /// <summary> Migrating means Azure Large Instance resource is being migrated from one subscription or resource group to another. </summary>
        public static LargeInstanceProvisioningState Migrating { get; } = new LargeInstanceProvisioningState(MigratingValue);
        /// <summary> Cancelled Azure Large Instance resource operation has been cancelled. </summary>
        public static LargeInstanceProvisioningState Canceled { get; } = new LargeInstanceProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="LargeInstanceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(LargeInstanceProvisioningState left, LargeInstanceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LargeInstanceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(LargeInstanceProvisioningState left, LargeInstanceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LargeInstanceProvisioningState"/>. </summary>
        public static implicit operator LargeInstanceProvisioningState(string value) => new LargeInstanceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LargeInstanceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LargeInstanceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
