// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LargeInstance.Models
{
    /// <summary> Enum of two possible values to determine if the ALI instance restart operation should forcefully terminate and halt any existing processes that may be running on the server or not. </summary>
    public readonly partial struct LargeInstanceForcePowerState : IEquatable<LargeInstanceForcePowerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LargeInstanceForcePowerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LargeInstanceForcePowerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string InactiveValue = "inactive";

        /// <summary> Active means that the restart operation will terminate and halt existing processes that may be running on the server. </summary>
        public static LargeInstanceForcePowerState Active { get; } = new LargeInstanceForcePowerState(ActiveValue);
        /// <summary> Inactive means that the restart operation will not terminate and halt existing processes that may be running on the server. </summary>
        public static LargeInstanceForcePowerState Inactive { get; } = new LargeInstanceForcePowerState(InactiveValue);
        /// <summary> Determines if two <see cref="LargeInstanceForcePowerState"/> values are the same. </summary>
        public static bool operator ==(LargeInstanceForcePowerState left, LargeInstanceForcePowerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LargeInstanceForcePowerState"/> values are not the same. </summary>
        public static bool operator !=(LargeInstanceForcePowerState left, LargeInstanceForcePowerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LargeInstanceForcePowerState"/>. </summary>
        public static implicit operator LargeInstanceForcePowerState(string value) => new LargeInstanceForcePowerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LargeInstanceForcePowerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LargeInstanceForcePowerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
