// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.LargeInstance
{
    /// <summary>
    /// A class representing a collection of <see cref="LargeStorageInstanceResource"/> and their operations.
    /// Each <see cref="LargeStorageInstanceResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="LargeStorageInstanceCollection"/> instance call the GetLargeStorageInstances method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class LargeStorageInstanceCollection : ArmCollection, IEnumerable<LargeStorageInstanceResource>, IAsyncEnumerable<LargeStorageInstanceResource>
    {
        private readonly ClientDiagnostics _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics;
        private readonly AzureLargeStorageInstanceRestOperations _largeStorageInstanceAzureLargeStorageInstanceRestClient;

        /// <summary> Initializes a new instance of the <see cref="LargeStorageInstanceCollection"/> class for mocking. </summary>
        protected LargeStorageInstanceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="LargeStorageInstanceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal LargeStorageInstanceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.LargeInstance", LargeStorageInstanceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(LargeStorageInstanceResource.ResourceType, out string largeStorageInstanceAzureLargeStorageInstanceApiVersion);
            _largeStorageInstanceAzureLargeStorageInstanceRestClient = new AzureLargeStorageInstanceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, largeStorageInstanceAzureLargeStorageInstanceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an Azure Large Storage instance for the specified subscription, resource
        /// group, and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual async Task<Response<LargeStorageInstanceResource>> GetAsync(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = await _largeStorageInstanceAzureLargeStorageInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LargeStorageInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an Azure Large Storage instance for the specified subscription, resource
        /// group, and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual Response<LargeStorageInstanceResource> Get(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = _largeStorageInstanceAzureLargeStorageInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LargeStorageInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of AzureLargeStorageInstances in the specified subscription and
        /// resource group. The operations returns various properties of each Azure
        /// LargeStorage instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LargeStorageInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LargeStorageInstanceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _largeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _largeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LargeStorageInstanceResource(Client, LargeStorageInstanceData.DeserializeLargeStorageInstanceData(e)), _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics, Pipeline, "LargeStorageInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of AzureLargeStorageInstances in the specified subscription and
        /// resource group. The operations returns various properties of each Azure
        /// LargeStorage instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LargeStorageInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LargeStorageInstanceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _largeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _largeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LargeStorageInstanceResource(Client, LargeStorageInstanceData.DeserializeLargeStorageInstanceData(e)), _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics, Pipeline, "LargeStorageInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _largeStorageInstanceAzureLargeStorageInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual Response<bool> Exists(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = _largeStorageInstanceAzureLargeStorageInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual async Task<NullableResponse<LargeStorageInstanceResource>> GetIfExistsAsync(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _largeStorageInstanceAzureLargeStorageInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<LargeStorageInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new LargeStorageInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        public virtual NullableResponse<LargeStorageInstanceResource> GetIfExists(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeStorageInstanceName, nameof(azureLargeStorageInstanceName));

            using var scope = _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics.CreateScope("LargeStorageInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _largeStorageInstanceAzureLargeStorageInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeStorageInstanceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<LargeStorageInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new LargeStorageInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<LargeStorageInstanceResource> IEnumerable<LargeStorageInstanceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<LargeStorageInstanceResource> IAsyncEnumerable<LargeStorageInstanceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
