// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.LargeInstance
{
    /// <summary>
    /// A class representing a collection of <see cref="LargeInstanceResource"/> and their operations.
    /// Each <see cref="LargeInstanceResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="LargeInstanceCollection"/> instance call the GetLargeInstances method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class LargeInstanceCollection : ArmCollection, IEnumerable<LargeInstanceResource>, IAsyncEnumerable<LargeInstanceResource>
    {
        private readonly ClientDiagnostics _largeInstanceAzureLargeInstanceClientDiagnostics;
        private readonly AzureLargeInstanceRestOperations _largeInstanceAzureLargeInstanceRestClient;

        /// <summary> Initializes a new instance of the <see cref="LargeInstanceCollection"/> class for mocking. </summary>
        protected LargeInstanceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="LargeInstanceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal LargeInstanceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _largeInstanceAzureLargeInstanceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.LargeInstance", LargeInstanceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(LargeInstanceResource.ResourceType, out string largeInstanceAzureLargeInstanceApiVersion);
            _largeInstanceAzureLargeInstanceRestClient = new AzureLargeInstanceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, largeInstanceAzureLargeInstanceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an Azure Large Instance for the specified subscription, resource group,
        /// and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual async Task<Response<LargeInstanceResource>> GetAsync(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = await _largeInstanceAzureLargeInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LargeInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an Azure Large Instance for the specified subscription, resource group,
        /// and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual Response<LargeInstanceResource> Get(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.Get");
            scope.Start();
            try
            {
                var response = _largeInstanceAzureLargeInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LargeInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of Azure Large Instances in the specified subscription and resource
        /// group. The operations returns various properties of each Azure Large Instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LargeInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LargeInstanceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _largeInstanceAzureLargeInstanceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _largeInstanceAzureLargeInstanceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LargeInstanceResource(Client, LargeInstanceData.DeserializeLargeInstanceData(e)), _largeInstanceAzureLargeInstanceClientDiagnostics, Pipeline, "LargeInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of Azure Large Instances in the specified subscription and resource
        /// group. The operations returns various properties of each Azure Large Instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LargeInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LargeInstanceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _largeInstanceAzureLargeInstanceRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _largeInstanceAzureLargeInstanceRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LargeInstanceResource(Client, LargeInstanceData.DeserializeLargeInstanceData(e)), _largeInstanceAzureLargeInstanceClientDiagnostics, Pipeline, "LargeInstanceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _largeInstanceAzureLargeInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual Response<bool> Exists(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.Exists");
            scope.Start();
            try
            {
                var response = _largeInstanceAzureLargeInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual async Task<NullableResponse<LargeInstanceResource>> GetIfExistsAsync(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _largeInstanceAzureLargeInstanceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<LargeInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new LargeInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        public virtual NullableResponse<LargeInstanceResource> GetIfExists(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureLargeInstanceName, nameof(azureLargeInstanceName));

            using var scope = _largeInstanceAzureLargeInstanceClientDiagnostics.CreateScope("LargeInstanceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _largeInstanceAzureLargeInstanceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, azureLargeInstanceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<LargeInstanceResource>(response.GetRawResponse());
                return Response.FromValue(new LargeInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<LargeInstanceResource> IEnumerable<LargeInstanceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<LargeInstanceResource> IAsyncEnumerable<LargeInstanceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
