// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.LargeInstance.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableLargeInstanceSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _largeInstanceAzureLargeInstanceClientDiagnostics;
        private AzureLargeInstanceRestOperations _largeInstanceAzureLargeInstanceRestClient;
        private ClientDiagnostics _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics;
        private AzureLargeStorageInstanceRestOperations _largeStorageInstanceAzureLargeStorageInstanceRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceSubscriptionResource"/> class for mocking. </summary>
        protected MockableLargeInstanceSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLargeInstanceSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics LargeInstanceAzureLargeInstanceClientDiagnostics => _largeInstanceAzureLargeInstanceClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.LargeInstance", LargeInstanceResource.ResourceType.Namespace, Diagnostics);
        private AzureLargeInstanceRestOperations LargeInstanceAzureLargeInstanceRestClient => _largeInstanceAzureLargeInstanceRestClient ??= new AzureLargeInstanceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(LargeInstanceResource.ResourceType));
        private ClientDiagnostics LargeStorageInstanceAzureLargeStorageInstanceClientDiagnostics => _largeStorageInstanceAzureLargeStorageInstanceClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.LargeInstance", LargeStorageInstanceResource.ResourceType.Namespace, Diagnostics);
        private AzureLargeStorageInstanceRestOperations LargeStorageInstanceAzureLargeStorageInstanceRestClient => _largeStorageInstanceAzureLargeStorageInstanceRestClient ??= new AzureLargeStorageInstanceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(LargeStorageInstanceResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets a list of Azure Large Instances in the specified subscription. The
        /// operations returns various properties of each Azure Large Instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureLargeInstance/azureLargeInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LargeInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LargeInstanceResource> GetLargeInstancesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LargeInstanceAzureLargeInstanceRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LargeInstanceAzureLargeInstanceRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LargeInstanceResource(Client, LargeInstanceData.DeserializeLargeInstanceData(e)), LargeInstanceAzureLargeInstanceClientDiagnostics, Pipeline, "MockableLargeInstanceSubscriptionResource.GetLargeInstances", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of Azure Large Instances in the specified subscription. The
        /// operations returns various properties of each Azure Large Instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureLargeInstance/azureLargeInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LargeInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LargeInstanceResource> GetLargeInstances(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LargeInstanceAzureLargeInstanceRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LargeInstanceAzureLargeInstanceRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LargeInstanceResource(Client, LargeInstanceData.DeserializeLargeInstanceData(e)), LargeInstanceAzureLargeInstanceClientDiagnostics, Pipeline, "MockableLargeInstanceSubscriptionResource.GetLargeInstances", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of AzureLargeStorageInstances in the specified subscription. The
        /// operations returns various properties of each Azure LargeStorage instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LargeStorageInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LargeStorageInstanceResource> GetLargeStorageInstancesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LargeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LargeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LargeStorageInstanceResource(Client, LargeStorageInstanceData.DeserializeLargeStorageInstanceData(e)), LargeStorageInstanceAzureLargeStorageInstanceClientDiagnostics, Pipeline, "MockableLargeInstanceSubscriptionResource.GetLargeStorageInstances", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of AzureLargeStorageInstances in the specified subscription. The
        /// operations returns various properties of each Azure LargeStorage instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LargeStorageInstanceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LargeStorageInstanceResource> GetLargeStorageInstances(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LargeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LargeStorageInstanceAzureLargeStorageInstanceRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LargeStorageInstanceResource(Client, LargeStorageInstanceData.DeserializeLargeStorageInstanceData(e)), LargeStorageInstanceAzureLargeStorageInstanceClientDiagnostics, Pipeline, "MockableLargeInstanceSubscriptionResource.GetLargeStorageInstances", "value", "nextLink", cancellationToken);
        }
    }
}
