// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.LargeInstance.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableLargeInstanceResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceResourceGroupResource"/> class for mocking. </summary>
        protected MockableLargeInstanceResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLargeInstanceResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of LargeInstanceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LargeInstanceResources and their operations over a LargeInstanceResource. </returns>
        public virtual LargeInstanceCollection GetLargeInstances()
        {
            return GetCachedClient(client => new LargeInstanceCollection(client, Id));
        }

        /// <summary>
        /// Gets an Azure Large Instance for the specified subscription, resource group,
        /// and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LargeInstanceResource>> GetLargeInstanceAsync(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            return await GetLargeInstances().GetAsync(azureLargeInstanceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an Azure Large Instance for the specified subscription, resource group,
        /// and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeInstanceName"> Name of the AzureLargeInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LargeInstanceResource> GetLargeInstance(string azureLargeInstanceName, CancellationToken cancellationToken = default)
        {
            return GetLargeInstances().Get(azureLargeInstanceName, cancellationToken);
        }

        /// <summary> Gets a collection of LargeStorageInstanceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LargeStorageInstanceResources and their operations over a LargeStorageInstanceResource. </returns>
        public virtual LargeStorageInstanceCollection GetLargeStorageInstances()
        {
            return GetCachedClient(client => new LargeStorageInstanceCollection(client, Id));
        }

        /// <summary>
        /// Gets an Azure Large Storage instance for the specified subscription, resource
        /// group, and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LargeStorageInstanceResource>> GetLargeStorageInstanceAsync(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            return await GetLargeStorageInstances().GetAsync(azureLargeStorageInstanceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an Azure Large Storage instance for the specified subscription, resource
        /// group, and instance name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeStorageInstances/{azureLargeStorageInstanceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureLargeStorageInstance_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-20-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LargeStorageInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureLargeStorageInstanceName"> Name of the AzureLargeStorageInstance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureLargeStorageInstanceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureLargeStorageInstanceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LargeStorageInstanceResource> GetLargeStorageInstance(string azureLargeStorageInstanceName, CancellationToken cancellationToken = default)
        {
            return GetLargeStorageInstances().Get(azureLargeStorageInstanceName, cancellationToken);
        }
    }
}
