// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.LargeInstance.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableLargeInstanceArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceArmClient"/> class for mocking. </summary>
        protected MockableLargeInstanceArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLargeInstanceArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLargeInstanceArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableLargeInstanceArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="LargeInstanceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LargeInstanceResource.CreateResourceIdentifier" /> to create a <see cref="LargeInstanceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LargeInstanceResource"/> object. </returns>
        public virtual LargeInstanceResource GetLargeInstanceResource(ResourceIdentifier id)
        {
            LargeInstanceResource.ValidateResourceId(id);
            return new LargeInstanceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LargeStorageInstanceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LargeStorageInstanceResource.CreateResourceIdentifier" /> to create a <see cref="LargeStorageInstanceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LargeStorageInstanceResource"/> object. </returns>
        public virtual LargeStorageInstanceResource GetLargeStorageInstanceResource(ResourceIdentifier id)
        {
            LargeStorageInstanceResource.ValidateResourceId(id);
            return new LargeStorageInstanceResource(Client, id);
        }
    }
}
