// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.LargeInstance.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.LargeInstance.Samples
{
    public partial class Sample_LargeStorageInstanceResource
    {
        // AzureLargeStorageInstance_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLargeStorageInstances_AzureLargeStorageInstanceListBySubscription()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeStorageInstance_ListBySubscription.json
            // this example is just showing the usage of "AzureLargeStorageInstance_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (LargeStorageInstanceResource item in subscriptionResource.GetLargeStorageInstancesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                LargeStorageInstanceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AzureLargeStorageInstance_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AzureLargeStorageInstanceGet()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeStorageInstance_Get.json
            // this example is just showing the usage of "AzureLargeStorageInstance_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeStorageInstanceResource created on azure
            // for more information of creating LargeStorageInstanceResource, please refer to the document of LargeStorageInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeStorageInstanceName = "myAzureLargeStorageInstance";
            ResourceIdentifier largeStorageInstanceResourceId = LargeStorageInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeStorageInstanceName);
            LargeStorageInstanceResource largeStorageInstance = client.GetLargeStorageInstanceResource(largeStorageInstanceResourceId);

            // invoke the operation
            LargeStorageInstanceResource result = await largeStorageInstance.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeStorageInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureLargeStorageInstance_Delete_Tag
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AzureLargeStorageInstanceDeleteTag()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeStorageInstance_PatchTags_Delete.json
            // this example is just showing the usage of "AzureLargeStorageInstance_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeStorageInstanceResource created on azure
            // for more information of creating LargeStorageInstanceResource, please refer to the document of LargeStorageInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeStorageInstanceName = "myALSInstance";
            ResourceIdentifier largeStorageInstanceResourceId = LargeStorageInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeStorageInstanceName);
            LargeStorageInstanceResource largeStorageInstance = client.GetLargeStorageInstanceResource(largeStorageInstanceResourceId);

            // invoke the operation
            LargeStorageInstancePatch patch = new LargeStorageInstancePatch();
            LargeStorageInstanceResource result = await largeStorageInstance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeStorageInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureLargeStorageInstance_Update_Tag
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AzureLargeStorageInstanceUpdateTag()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeStorageInstance_PatchTags.json
            // this example is just showing the usage of "AzureLargeStorageInstance_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeStorageInstanceResource created on azure
            // for more information of creating LargeStorageInstanceResource, please refer to the document of LargeStorageInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeStorageInstanceName = "myALSInstance";
            ResourceIdentifier largeStorageInstanceResourceId = LargeStorageInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeStorageInstanceName);
            LargeStorageInstanceResource largeStorageInstance = client.GetLargeStorageInstanceResource(largeStorageInstanceResourceId);

            // invoke the operation
            LargeStorageInstancePatch patch = new LargeStorageInstancePatch();
            LargeStorageInstanceResource result = await largeStorageInstance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeStorageInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
