// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.LargeInstance.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.LargeInstance.Samples
{
    public partial class Sample_LargeInstanceResource
    {
        // AzureLargeInstance_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLargeInstances_AzureLargeInstanceListBySubscription()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_ListBySubscription.json
            // this example is just showing the usage of "AzureLargeInstance_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (LargeInstanceResource item in subscriptionResource.GetLargeInstancesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                LargeInstanceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AzureLargeInstance_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AzureLargeInstanceGet()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_Get.json
            // this example is just showing the usage of "AzureLargeInstance_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myAzureLargeInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            LargeInstanceResource result = await largeInstance.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureLargeInstance_Delete_Tag
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AzureLargeInstanceDeleteTag()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_PatchTags_Delete.json
            // this example is just showing the usage of "AzureLargeInstance_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myALInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            LargeInstancePatch patch = new LargeInstancePatch();
            LargeInstanceResource result = await largeInstance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureLargeInstance_Update_Tag
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AzureLargeInstanceUpdateTag()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_PatchTags.json
            // this example is just showing the usage of "AzureLargeInstance_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "f0f4887f-d13c-4943-a8ba-d7da28d2a3fd";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myALInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            LargeInstancePatch patch = new LargeInstancePatch();
            LargeInstanceResource result = await largeInstance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LargeInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureLargeInstance_Restart
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Restart_AzureLargeInstanceRestart()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_Restart.json
            // this example is just showing the usage of "AzureLargeInstance_Restart" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myALInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            ArmOperation<LargeInstanceOperationStatusResult> lro = await largeInstance.RestartAsync(WaitUntil.Completed);
            LargeInstanceOperationStatusResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // AzureLargeInstance_Shutdown
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Shutdown_AzureLargeInstanceShutdown()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_Shutdown.json
            // this example is just showing the usage of "AzureLargeInstance_Shutdown" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myALInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            ArmOperation<LargeInstanceOperationStatusResult> lro = await largeInstance.ShutdownAsync(WaitUntil.Completed);
            LargeInstanceOperationStatusResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // AzureLargeInstance_Start
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Start_AzureLargeInstanceStart()
        {
            // Generated from example definition: specification/azurelargeinstance/resource-manager/Microsoft.AzureLargeInstance/preview/2023-07-20-preview/examples/AzureLargeInstance_Start.json
            // this example is just showing the usage of "AzureLargeInstance_Start" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LargeInstanceResource created on azure
            // for more information of creating LargeInstanceResource, please refer to the document of LargeInstanceResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string azureLargeInstanceName = "myALInstance";
            ResourceIdentifier largeInstanceResourceId = LargeInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureLargeInstanceName);
            LargeInstanceResource largeInstance = client.GetLargeInstanceResource(largeInstanceResourceId);

            // invoke the operation
            ArmOperation<LargeInstanceOperationStatusResult> lro = await largeInstance.StartAsync(WaitUntil.Completed);
            LargeInstanceOperationStatusResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
