// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing the WorkloadNetworkSegment data model.
    /// NSX Segment
    /// </summary>
    public partial class WorkloadNetworkSegmentData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkSegmentData"/>. </summary>
        public WorkloadNetworkSegmentData()
        {
            PortVif = new ChangeTrackingList<WorkloadNetworkSegmentPortVif>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkSegmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Display name of the segment. </param>
        /// <param name="connectedGateway"> Gateway which to connect segment to. </param>
        /// <param name="subnet"> Subnet which to connect segment to. </param>
        /// <param name="portVif"> Port Vif which segment is associated with. </param>
        /// <param name="status"> Segment status. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="revision"> NSX revision number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkloadNetworkSegmentData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, string connectedGateway, WorkloadNetworkSegmentSubnet subnet, IReadOnlyList<WorkloadNetworkSegmentPortVif> portVif, WorkloadNetworkSegmentStatus? status, WorkloadNetworkSegmentProvisioningState? provisioningState, long? revision, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            ConnectedGateway = connectedGateway;
            Subnet = subnet;
            PortVif = portVif;
            Status = status;
            ProvisioningState = provisioningState;
            Revision = revision;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the segment. </summary>
        public string DisplayName { get; set; }
        /// <summary> Gateway which to connect segment to. </summary>
        public string ConnectedGateway { get; set; }
        /// <summary> Subnet which to connect segment to. </summary>
        public WorkloadNetworkSegmentSubnet Subnet { get; set; }
        /// <summary> Port Vif which segment is associated with. </summary>
        public IReadOnlyList<WorkloadNetworkSegmentPortVif> PortVif { get; }
        /// <summary> Segment status. </summary>
        public WorkloadNetworkSegmentStatus? Status { get; }
        /// <summary> The provisioning state. </summary>
        public WorkloadNetworkSegmentProvisioningState? ProvisioningState { get; }
        /// <summary> NSX revision number. </summary>
        public long? Revision { get; set; }
    }
}
