// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing the WorkloadNetworkPublicIP data model.
    /// NSX Public IP Block
    /// </summary>
    public partial class WorkloadNetworkPublicIPData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkPublicIPData"/>. </summary>
        public WorkloadNetworkPublicIPData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkPublicIPData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Display name of the Public IP Block. </param>
        /// <param name="numberOfPublicIPs"> Number of Public IPs requested. </param>
        /// <param name="publicIPBlock"> CIDR Block of the Public IP Block. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkloadNetworkPublicIPData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, long? numberOfPublicIPs, string publicIPBlock, WorkloadNetworkPublicIPProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            NumberOfPublicIPs = numberOfPublicIPs;
            PublicIPBlock = publicIPBlock;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the Public IP Block. </summary>
        public string DisplayName { get; set; }
        /// <summary> Number of Public IPs requested. </summary>
        public long? NumberOfPublicIPs { get; set; }
        /// <summary> CIDR Block of the Public IP Block. </summary>
        public string PublicIPBlock { get; }
        /// <summary> The provisioning state. </summary>
        public WorkloadNetworkPublicIPProvisioningState? ProvisioningState { get; }
    }
}
