// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing the WorkloadNetworkDnsZone data model.
    /// NSX DNS Zone
    /// </summary>
    public partial class WorkloadNetworkDnsZoneData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkDnsZoneData"/>. </summary>
        public WorkloadNetworkDnsZoneData()
        {
            Domain = new ChangeTrackingList<string>();
            DnsServerIPs = new ChangeTrackingList<IPAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadNetworkDnsZoneData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Display name of the DNS Zone. </param>
        /// <param name="domain"> Domain names of the DNS Zone. </param>
        /// <param name="dnsServerIPs"> DNS Server IP array of the DNS Zone. </param>
        /// <param name="sourceIP"> Source IP of the DNS Zone. </param>
        /// <param name="dnsServices"> Number of DNS Services using the DNS zone. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="revision"> NSX revision number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkloadNetworkDnsZoneData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, IList<string> domain, IList<IPAddress> dnsServerIPs, IPAddress sourceIP, long? dnsServices, WorkloadNetworkDnsZoneProvisioningState? provisioningState, long? revision, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            Domain = domain;
            DnsServerIPs = dnsServerIPs;
            SourceIP = sourceIP;
            DnsServices = dnsServices;
            ProvisioningState = provisioningState;
            Revision = revision;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the DNS Zone. </summary>
        public string DisplayName { get; set; }
        /// <summary> Domain names of the DNS Zone. </summary>
        public IList<string> Domain { get; }
        /// <summary> DNS Server IP array of the DNS Zone. </summary>
        public IList<IPAddress> DnsServerIPs { get; }
        /// <summary> Source IP of the DNS Zone. </summary>
        public IPAddress SourceIP { get; set; }
        /// <summary> Number of DNS Services using the DNS zone. </summary>
        public long? DnsServices { get; set; }
        /// <summary> The provisioning state. </summary>
        public WorkloadNetworkDnsZoneProvisioningState? ProvisioningState { get; }
        /// <summary> NSX revision number. </summary>
        public long? Revision { get; set; }
    }
}
