// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Avs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Avs
{
    /// <summary>
    /// A class representing the ScriptCmdlet data model.
    /// A cmdlet available for script execution
    /// </summary>
    public partial class ScriptCmdletData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScriptCmdletData"/>. </summary>
        public ScriptCmdletData()
        {
            Parameters = new ChangeTrackingList<ScriptParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="ScriptCmdletData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="description"> Description of the scripts functionality. </param>
        /// <param name="timeout"> Recommended time limit for execution. </param>
        /// <param name="audience"> Specifies whether a script cmdlet is intended to be invoked only through automation or visible to customers. </param>
        /// <param name="parameters"> Parameters the script will accept. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScriptCmdletData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ScriptCmdletProvisioningState? provisioningState, string description, TimeSpan? timeout, ScriptCmdletAudience? audience, IReadOnlyList<ScriptParameter> parameters, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            Description = description;
            Timeout = timeout;
            Audience = audience;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the resource. </summary>
        public ScriptCmdletProvisioningState? ProvisioningState { get; }
        /// <summary> Description of the scripts functionality. </summary>
        public string Description { get; }
        /// <summary> Recommended time limit for execution. </summary>
        public TimeSpan? Timeout { get; }
        /// <summary> Specifies whether a script cmdlet is intended to be invoked only through automation or visible to customers. </summary>
        public ScriptCmdletAudience? Audience { get; }
        /// <summary> Parameters the script will accept. </summary>
        public IReadOnlyList<ScriptParameter> Parameters { get; }
    }
}
